/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.file;

import com.cedarsoft.file.BaseName;
import com.cedarsoft.file.FileName;
import com.cedarsoft.file.FileNames;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class BaseNameAwareFileNames {
    @Nonnull
    private final SortedMap<BaseName, FileNames> entries = new TreeMap<BaseName, FileNames>();

    public void add(@Nonnull FileName fileName) {
        this.getEntry(fileName.getBaseName()).add(fileName);
    }

    @Nonnull
    public Collection<? extends Map.Entry<BaseName, FileNames>> getEntries() {
        return Collections.unmodifiableCollection(this.entries.entrySet());
    }

    @Nonnull
    public FileNames getEntry(@Nonnull BaseName baseName) {
        FileNames found = (FileNames)this.entries.get(baseName);
        if (found != null) {
            return found;
        }
        FileNames created = new FileNames();
        this.entries.put(baseName, created);
        return created;
    }

    public int size() {
        return this.entries.size();
    }
}

