/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.collections;

import com.cedarsoft.collections.ListChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class ListChangeSupport<T> {
    private List<ListChangeListener<T>> listeners = new ArrayList<ListChangeListener<T>>();

    public boolean add(@Nonnull List<T> backend, @Nonnull T element) {
        int index = backend.size();
        boolean returnValue = backend.add(element);
        this.fireAddEvent(index, element);
        return returnValue;
    }

    public void fireAddEvent(int index, @Nonnull T element) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListChangeListener<T> listener : new ArrayList<ListChangeListener<T>>(this.listeners)) {
            listener.elementAdded(index, element);
        }
    }

    public void fireRemoveEvent(int index, @Nonnull T element) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListChangeListener<T> listener : new ArrayList<ListChangeListener<T>>(this.listeners)) {
            listener.elementRemoved(index, element);
        }
    }

    public boolean remove(@Nonnull List<T> backend, @Nonnull T element) {
        int index = backend.indexOf(element);
        boolean returnValue = backend.remove(element);
        this.fireRemoveEvent(index, element);
        return returnValue;
    }

    public void addListener(@Nonnull ListChangeListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(@Nonnull ListChangeListener<T> listener) {
        this.listeners.remove(listener);
    }

    @Nonnull
    public List<ListChangeListener<T>> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

