/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.annotations.verification;

import com.cedarsoft.annotations.verification.UiThreadVerificationStrategy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

public class SwtUiThreadVerificationStrategy
implements UiThreadVerificationStrategy {
    @Nullable
    private final Method swtGetCurrentMethod;

    @Nullable
    private static Method detectSwtGetCurrentMethod() {
        try {
            Class<?> display = Class.forName("org.eclipse.swt.widgets.Display");
            return display.getMethod("getCurrent", new Class[0]);
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public SwtUiThreadVerificationStrategy() {
        this(SwtUiThreadVerificationStrategy.detectSwtGetCurrentMethod());
    }

    public SwtUiThreadVerificationStrategy(@Nullable Method swtGetCurrentMethod) {
        this.swtGetCurrentMethod = swtGetCurrentMethod;
    }

    @Override
    public boolean isUiThread() {
        try {
            return this.swtGetCurrentMethod != null && this.swtGetCurrentMethod.invoke(null, new Object[0]) != null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

