/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.annotations.verification;

import com.cedarsoft.annotations.verification.UiThreadVerificationStrategy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

public class JavaFxUiThreadVerificationStrategy
implements UiThreadVerificationStrategy {
    @Nullable
    private final Method fxIsFxApplicationThreadMethod;

    @Nullable
    private static Method detectFxMethod() {
        try {
            Class<?> display = Class.forName("javafx.application.Platform");
            return display.getMethod("isFxApplicationThread", new Class[0]);
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public JavaFxUiThreadVerificationStrategy() {
        this(JavaFxUiThreadVerificationStrategy.detectFxMethod());
    }

    public JavaFxUiThreadVerificationStrategy(@Nullable Method fxIsFxApplicationThreadMethod) {
        this.fxIsFxApplicationThreadMethod = fxIsFxApplicationThreadMethod;
    }

    @Override
    public boolean isUiThread() {
        try {
            return this.fxIsFxApplicationThreadMethod != null && this.fxIsFxApplicationThreadMethod.invoke(null, new Object[0]) == Boolean.TRUE;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

