/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import [Ljava.lang.Object;;
import [Ljava.lang.String;;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.ArrayDeserializer;
import com.caucho.hessian.io.ArraySerializer;
import com.caucho.hessian.io.BasicDeserializer;
import com.caucho.hessian.io.BasicSerializer;
import com.caucho.hessian.io.ClassDeserializer;
import com.caucho.hessian.io.ClassSerializer;
import com.caucho.hessian.io.CollectionDeserializer;
import com.caucho.hessian.io.CollectionSerializer;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.HessianRemoteObject;
import com.caucho.hessian.io.InputStreamSerializer;
import com.caucho.hessian.io.JavaDeserializer;
import com.caucho.hessian.io.JavaSerializer;
import com.caucho.hessian.io.MapDeserializer;
import com.caucho.hessian.io.MapSerializer;
import com.caucho.hessian.io.RemoteSerializer;
import com.caucho.hessian.io.Serializer;
import com.caucho.hessian.io.SqlDateDeserializer;
import com.caucho.hessian.io.SqlDateSerializer;
import com.caucho.hessian.io.StackTraceElementDeserializer;
import com.caucho.hessian.io.StringValueDeserializer;
import com.caucho.hessian.io.StringValueSerializer;
import com.caucho.hessian.io.ThrowableSerializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SerializerFactory {
    private static HashMap _serializerMap = new HashMap();
    private static HashMap _deserializerMap = new HashMap();
    private static HashMap _typeMap = new HashMap();
    protected Serializer _defaultSerializer;
    private Deserializer _hashMapDeserializer;
    private HashMap _cachedSerializerMap;
    private HashMap _cachedDeserializerMap;
    private HashMap _cachedTypeDeserializerMap;

    public Serializer getSerializer(Class cl) throws HessianProtocolException {
        Serializer serializer = (Serializer)_serializerMap.get(cl);
        if (serializer != null) {
            return serializer;
        }
        if (this._cachedSerializerMap != null && (serializer = (Serializer)this._cachedSerializerMap.get(cl)) != null) {
            return serializer;
        }
        serializer = HessianRemoteObject.class.isAssignableFrom(cl) ? new RemoteSerializer() : (Map.class.isAssignableFrom(cl) ? new MapSerializer() : (Collection.class.isAssignableFrom(cl) ? new CollectionSerializer() : (cl.isArray() ? new ArraySerializer() : (Throwable.class.isAssignableFrom(cl) ? new ThrowableSerializer() : (InputStream.class.isAssignableFrom(cl) ? new InputStreamSerializer() : this.getDefaultSerializer(cl))))));
        if (this._cachedSerializerMap == null) {
            this._cachedSerializerMap = new HashMap(8);
        }
        this._cachedSerializerMap.put(cl, serializer);
        return serializer;
    }

    protected Serializer getDefaultSerializer(Class cl) {
        if (this._defaultSerializer != null) {
            return this._defaultSerializer;
        }
        return new JavaSerializer(cl);
    }

    public Deserializer getDeserializer(Class cl) throws HessianProtocolException {
        Deserializer deserializer = (Deserializer)_deserializerMap.get(cl);
        if (deserializer != null) {
            return deserializer;
        }
        if (this._cachedDeserializerMap != null && (deserializer = (Deserializer)this._cachedDeserializerMap.get(cl)) != null) {
            return deserializer;
        }
        deserializer = Collection.class.isAssignableFrom(cl) ? new CollectionDeserializer(cl) : (Map.class.isAssignableFrom(cl) ? new MapDeserializer(cl) : (cl.isArray() ? new ArrayDeserializer(this.getDeserializer(cl.getComponentType())) : this.getDefaultDeserializer(cl)));
        if (this._cachedDeserializerMap == null) {
            this._cachedDeserializerMap = new HashMap(8);
        }
        this._cachedDeserializerMap.put(cl, deserializer);
        return deserializer;
    }

    protected Deserializer getDefaultDeserializer(Class cl) {
        return new JavaDeserializer(cl);
    }

    public Object readList(AbstractHessianInput in, int length, String type) throws HessianProtocolException, IOException {
        Deserializer deserializer = this.getDeserializer(type);
        if (deserializer != null) {
            return deserializer.readList(in, length);
        }
        return new CollectionDeserializer(ArrayList.class).readList(in, length);
    }

    public Object readMap(AbstractHessianInput in, String type) throws HessianProtocolException, IOException {
        Deserializer deserializer = this.getDeserializer(type);
        if (deserializer != null) {
            return deserializer.readMap(in);
        }
        if (this._hashMapDeserializer != null) {
            return this._hashMapDeserializer.readMap(in);
        }
        this._hashMapDeserializer = new MapDeserializer(HashMap.class);
        return this._hashMapDeserializer.readMap(in);
    }

    public Deserializer getObjectDeserializer(String type) throws HessianProtocolException {
        Deserializer deserializer = this.getDeserializer(type);
        if (deserializer != null) {
            return deserializer;
        }
        if (this._hashMapDeserializer != null) {
            return this._hashMapDeserializer;
        }
        this._hashMapDeserializer = new MapDeserializer(HashMap.class);
        return this._hashMapDeserializer;
    }

    public Deserializer getDeserializer(String type) throws HessianProtocolException {
        Deserializer deserializer;
        if (type == null || type.equals("")) {
            return null;
        }
        if (this._cachedTypeDeserializerMap != null) {
            deserializer = (Deserializer)this._cachedTypeDeserializerMap.get(type);
        }
        if ((deserializer = (Deserializer)_typeMap.get(type)) != null) {
            return deserializer;
        }
        if (type.startsWith("[")) {
            Deserializer subDeserializer = this.getDeserializer(type.substring(1));
            deserializer = new ArrayDeserializer(subDeserializer);
        } else {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> cl = Class.forName(type, false, loader);
                deserializer = this.getDeserializer(cl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (deserializer != null) {
            if (this._cachedTypeDeserializerMap == null) {
                this._cachedTypeDeserializerMap = new HashMap(8);
            }
            this._cachedTypeDeserializerMap.put(type, deserializer);
        }
        return deserializer;
    }

    private static void addBasic(Class cl, String typeName, int type) {
        _serializerMap.put(cl, new BasicSerializer(type));
        BasicDeserializer deserializer = new BasicDeserializer(type);
        _deserializerMap.put(cl, deserializer);
        _typeMap.put(typeName, deserializer);
    }

    static {
        SerializerFactory.addBasic(Boolean.class, "boolean", 1);
        SerializerFactory.addBasic(Byte.class, "byte", 2);
        SerializerFactory.addBasic(Short.class, "short", 3);
        SerializerFactory.addBasic(Integer.class, "int", 4);
        SerializerFactory.addBasic(Long.class, "long", 5);
        SerializerFactory.addBasic(Float.class, "float", 6);
        SerializerFactory.addBasic(Double.class, "double", 7);
        SerializerFactory.addBasic(Character.class, "char", 8);
        SerializerFactory.addBasic(String.class, "string", 9);
        SerializerFactory.addBasic(java.util.Date.class, "date", 10);
        SerializerFactory.addBasic(Boolean.TYPE, "boolean", 1);
        SerializerFactory.addBasic(Byte.TYPE, "byte", 2);
        SerializerFactory.addBasic(Short.TYPE, "short", 3);
        SerializerFactory.addBasic(Integer.TYPE, "int", 4);
        SerializerFactory.addBasic(Long.TYPE, "long", 5);
        SerializerFactory.addBasic(Float.TYPE, "float", 6);
        SerializerFactory.addBasic(Double.TYPE, "double", 7);
        SerializerFactory.addBasic(Character.TYPE, "char", 8);
        SerializerFactory.addBasic([Z.class, "[boolean", 11);
        SerializerFactory.addBasic([B.class, "[byte", 12);
        SerializerFactory.addBasic([S.class, "[short", 13);
        SerializerFactory.addBasic([I.class, "[int", 14);
        SerializerFactory.addBasic([J.class, "[long", 15);
        SerializerFactory.addBasic([F.class, "[float", 16);
        SerializerFactory.addBasic([D.class, "[double", 17);
        SerializerFactory.addBasic([C.class, "[char", 18);
        SerializerFactory.addBasic(String;.class, "[string", 19);
        SerializerFactory.addBasic(Object;.class, "[object", 20);
        _serializerMap.put(Class.class, new ClassSerializer());
        _deserializerMap.put(Class.class, new ClassDeserializer());
        _serializerMap.put(BigDecimal.class, new StringValueSerializer());
        try {
            _deserializerMap.put(BigDecimal.class, new StringValueDeserializer(BigDecimal.class));
        }
        catch (Throwable e) {
            // empty catch block
        }
        _serializerMap.put(File.class, new StringValueSerializer());
        try {
            _deserializerMap.put(File.class, new StringValueDeserializer(File.class));
        }
        catch (Throwable e) {
            // empty catch block
        }
        _serializerMap.put(Date.class, new SqlDateSerializer());
        _serializerMap.put(Time.class, new SqlDateSerializer());
        _serializerMap.put(Timestamp.class, new SqlDateSerializer());
        try {
            _deserializerMap.put(Date.class, new SqlDateDeserializer(Date.class));
            _deserializerMap.put(Time.class, new SqlDateDeserializer(Time.class));
            _deserializerMap.put(Timestamp.class, new SqlDateDeserializer(Timestamp.class));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            Class<?> stackTrace = Class.forName("java.lang.StackTraceElement");
            _deserializerMap.put(stackTrace, new StackTraceElementDeserializer());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

