/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.client;

import com.caucho.hessian.client.HessianMetaInfoAPI;
import com.caucho.hessian.client.HessianProxy;
import com.caucho.hessian.client.HessianProxyResolver;
import com.caucho.hessian.client.HessianRuntimeException;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.HessianRemoteObject;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.services.client.ServiceProxyFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class HessianProxyFactory
implements ServiceProxyFactory,
ObjectFactory {
    private HessianRemoteResolver _resolver = new HessianProxyResolver(this);
    private String _user;
    private String _password;
    private String _basicAuth;
    private boolean _isOverloadEnabled = false;

    public void setUser(String user) {
        this._user = user;
        this._basicAuth = null;
    }

    public void setPassword(String password) {
        this._password = password;
        this._basicAuth = null;
    }

    public boolean isOverloadEnabled() {
        return this._isOverloadEnabled;
    }

    public void setOverloadEnabled(boolean isOverloadEnabled) {
        this._isOverloadEnabled = isOverloadEnabled;
    }

    public HessianRemoteResolver getRemoteResolver() {
        return this._resolver;
    }

    protected URLConnection openConnection(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        if (this._basicAuth != null) {
            conn.setRequestProperty("Authorization", this._basicAuth);
        } else if (this._user != null && this._password != null) {
            this._basicAuth = "Basic " + this.base64(this._user + ":" + this._password);
            conn.setRequestProperty("Authorization", this._basicAuth);
        }
        return conn;
    }

    public Object create(String url) throws MalformedURLException, ClassNotFoundException {
        HessianMetaInfoAPI metaInfo = (HessianMetaInfoAPI)this.create(HessianMetaInfoAPI.class, url);
        String apiClassName = (String)metaInfo._hessian_getAttribute("java.api.class");
        if (apiClassName == null) {
            throw new HessianRuntimeException(url + " has an unknown api.");
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> apiClass = Class.forName(apiClassName, false, loader);
        return this.create(apiClass, url);
    }

    public Object create(Class api, String url) throws MalformedURLException {
        HessianProxy handler = new HessianProxy(this, new URL(url));
        return Proxy.newProxyInstance(api.getClassLoader(), new Class[]{api, HessianRemoteObject.class}, (InvocationHandler)handler);
    }

    public AbstractHessianInput getHessianInput(InputStream is) {
        HessianInput in = new HessianInput(is);
        in.setRemoteResolver(this.getRemoteResolver());
        return in;
    }

    public HessianOutput getHessianOutput(OutputStream os) {
        HessianOutput out = new HessianOutput(os);
        return out;
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        Reference ref = (Reference)obj;
        String api = null;
        String url = null;
        Object user = null;
        Object password = null;
        for (int i = 0; i < ref.size(); ++i) {
            RefAddr addr = ref.get(i);
            String type = addr.getType();
            String value = (String)addr.getContent();
            if (type.equals("type")) {
                api = value;
                continue;
            }
            if (type.equals("url")) {
                url = value;
                continue;
            }
            if (type.equals("user")) {
                this.setUser(value);
                continue;
            }
            if (!type.equals("password")) continue;
            this.setPassword(value);
        }
        if (url == null) {
            throw new NamingException("`url' must be configured for HessianProxyFactory.");
        }
        if (api == null) {
            throw new NamingException("`type' must be configured for HessianProxyFactory.");
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> apiClass = Class.forName(api, false, loader);
        return this.create(apiClass, url);
    }

    private String base64(String value) {
        long chunk;
        StringBuffer cb = new StringBuffer();
        int i = 0;
        i = 0;
        while (i + 2 < value.length()) {
            chunk = value.charAt(i);
            chunk = (chunk << 8) + (long)value.charAt(i + 1);
            chunk = (chunk << 8) + (long)value.charAt(i + 2);
            cb.append(HessianProxyFactory.encode(chunk >> 18));
            cb.append(HessianProxyFactory.encode(chunk >> 12));
            cb.append(HessianProxyFactory.encode(chunk >> 6));
            cb.append(HessianProxyFactory.encode(chunk));
            i += 3;
        }
        if (i + 1 < value.length()) {
            chunk = value.charAt(i);
            chunk = (chunk << 8) + (long)value.charAt(i + 1);
            cb.append(HessianProxyFactory.encode((chunk <<= 8) >> 18));
            cb.append(HessianProxyFactory.encode(chunk >> 12));
            cb.append(HessianProxyFactory.encode(chunk >> 6));
            cb.append('=');
        } else if (i < value.length()) {
            chunk = value.charAt(i);
            cb.append(HessianProxyFactory.encode((chunk <<= 16) >> 18));
            cb.append(HessianProxyFactory.encode(chunk >> 12));
            cb.append('=');
            cb.append('=');
        }
        return cb.toString();
    }

    public static char encode(long d) {
        if ((d &= 0x3FL) < 26L) {
            return (char)(d + 65L);
        }
        if (d < 52L) {
            return (char)(d + 97L - 26L);
        }
        if (d < 62L) {
            return (char)(d + 48L - 52L);
        }
        if (d == 62L) {
            return '+';
        }
        return '/';
    }
}

