/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

public final class SysGlobals {
    public static final String CHILDVM_SYSPROP_JVM_ID = "junit4.childvm.id";
    public static final String CHILDVM_SYSPROP_JVM_COUNT = "junit4.childvm.count";
    private static final Object lock = new Object();
    private static final String DEFAULT_PREFIX = "tests";
    private static final String SYSPROP_PREFIX = "tests.prefix";
    private static SysGlobals singleton;
    private static StackTraceElement[] singletonInitStack;
    private final String prefix;
    private final String SYSPROP_STACKFILTERING;
    private final String SYSPROP_RANDOM_SEED;
    private final String SYSPROP_ITERATIONS;
    private final String SYSPROP_TESTCLASS;
    private final String SYSPROP_TESTMETHOD;
    private final String SYSPROP_TESTFILTER;
    private final String SYSPROP_KILLATTEMPTS;
    private final String SYSPROP_KILLWAIT;
    private final String SYSPROP_TIMEOUT;
    private final String SYSPROP_TIMEOUT_SUITE;
    private final String SYSPROP_APPEND_SEED;
    private final String SYSPROP_ASSERTS;

    private SysGlobals(String prefix) {
        this.prefix = prefix;
        this.SYSPROP_STACKFILTERING = this.prefixWith(prefix, "stackfiltering");
        this.SYSPROP_RANDOM_SEED = this.prefixWith(prefix, "seed");
        this.SYSPROP_ITERATIONS = this.prefixWith(prefix, "iters");
        this.SYSPROP_TESTCLASS = this.prefixWith(prefix, "class");
        this.SYSPROP_TESTMETHOD = this.prefixWith(prefix, "method");
        this.SYSPROP_TESTFILTER = this.prefixWith(prefix, "filter");
        this.SYSPROP_KILLATTEMPTS = this.prefixWith(prefix, "killattempts");
        this.SYSPROP_KILLWAIT = this.prefixWith(prefix, "killwait");
        this.SYSPROP_TIMEOUT = this.prefixWith(prefix, "timeout");
        this.SYSPROP_TIMEOUT_SUITE = this.prefixWith(prefix, "timeoutSuite");
        this.SYSPROP_APPEND_SEED = this.prefixWith(prefix, "appendseed");
        this.SYSPROP_ASSERTS = this.prefixWith(prefix, "asserts");
    }

    private String prefixWith(String prefix, String propertyName) {
        if (prefix.isEmpty()) {
            return propertyName;
        }
        return prefix + (prefix.endsWith(".") ? "" : ".") + propertyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SysGlobals singleton() {
        Object object = lock;
        synchronized (object) {
            if (singleton == null) {
                String prefix = System.getProperty(SYSPROP_PREFIX);
                if (prefix == null) {
                    prefix = DEFAULT_PREFIX;
                }
                SysGlobals.initializeWith(prefix);
            }
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SysGlobals initializeWith(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix must not be null.");
        }
        Object object = lock;
        synchronized (object) {
            if (singleton == null) {
                singleton = new SysGlobals(prefix);
                singletonInitStack = Thread.currentThread().getStackTrace();
            }
            if (!SysGlobals.singleton.prefix.equals(prefix)) {
                Exception e = new Exception("Original singleton initialization stack.");
                e.setStackTrace(singletonInitStack);
                throw new RuntimeException("A singleton has been initialized already with a different prefix: existing=" + SysGlobals.singleton.prefix + ", attempted=" + prefix, e);
            }
            return singleton;
        }
    }

    public static String SYSPROP_PREFIX() {
        return SYSPROP_PREFIX;
    }

    public static String CURRENT_PREFIX() {
        return SysGlobals.singleton().prefix;
    }

    public static String SYSPROP_STACKFILTERING() {
        return SysGlobals.singleton().SYSPROP_STACKFILTERING;
    }

    public static String SYSPROP_RANDOM_SEED() {
        return SysGlobals.singleton().SYSPROP_RANDOM_SEED;
    }

    public static String SYSPROP_ITERATIONS() {
        return SysGlobals.singleton().SYSPROP_ITERATIONS;
    }

    public static String SYSPROP_TESTCLASS() {
        return SysGlobals.singleton().SYSPROP_TESTCLASS;
    }

    public static String SYSPROP_TESTMETHOD() {
        return SysGlobals.singleton().SYSPROP_TESTMETHOD;
    }

    public static String SYSPROP_TESTFILTER() {
        return SysGlobals.singleton().SYSPROP_TESTFILTER;
    }

    public static String SYSPROP_KILLATTEMPTS() {
        return SysGlobals.singleton().SYSPROP_KILLATTEMPTS;
    }

    public static String SYSPROP_KILLWAIT() {
        return SysGlobals.singleton().SYSPROP_KILLWAIT;
    }

    public static String SYSPROP_TIMEOUT() {
        return SysGlobals.singleton().SYSPROP_TIMEOUT;
    }

    public static String SYSPROP_TIMEOUT_SUITE() {
        return SysGlobals.singleton().SYSPROP_TIMEOUT_SUITE;
    }

    public static String SYSPROP_APPEND_SEED() {
        return SysGlobals.singleton().SYSPROP_APPEND_SEED;
    }

    public static String SYSPROP_ASSERTS() {
        return SysGlobals.singleton().SYSPROP_ASSERTS;
    }

    public static String prefixProperty(String propertyName) {
        return SysGlobals.singleton().prefixWith(SysGlobals.singleton.prefix, propertyName);
    }
}

