/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueFunction;
import com.caoccao.javet.values.reference.IV8ValuePromise;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;

public class V8ValuePromise
extends V8ValueObject
implements IV8ValuePromise {
    V8ValuePromise(V8Runtime v8Runtime, long handle) throws JavetException {
        super(v8Runtime, handle);
    }

    @Override
    public V8ValuePromise _catch(IV8ValueFunction functionCatch) throws JavetException {
        return this.checkV8Runtime().getV8Internal().promiseCatch(this, functionCatch);
    }

    @Override
    public V8ValuePromise getPromise() throws JavetException {
        return this.checkV8Runtime().getV8Internal().promiseGetPromise(this);
    }

    @Override
    public <Value extends V8Value> Value getResult() throws JavetException {
        return (Value)this.checkV8Runtime().getV8Internal().promiseGetResult(this);
    }

    @Override
    public int getState() throws JavetException {
        return this.checkV8Runtime().getV8Internal().promiseGetState(this);
    }

    @Override
    public V8ValueReferenceType getType() {
        return V8ValueReferenceType.Promise;
    }

    @Override
    public boolean hasHandler() throws JavetException {
        return this.checkV8Runtime().getV8Internal().promiseHasHandler(this);
    }

    @Override
    public void markAsHandled() throws JavetException {
        this.checkV8Runtime().getV8Internal().promiseMarkAsHandled(this);
    }

    @Override
    public boolean register(IV8ValuePromise.IListener listener) throws JavetException {
        this.checkV8Runtime();
        try {
            JavetCallbackContext contextOnCatch = new JavetCallbackContext("onCatch", listener, listener.getClass().getMethod("onCatch", V8Value.class));
            JavetCallbackContext contextOnFulfilled = new JavetCallbackContext("onFulfilled", listener, listener.getClass().getMethod("onFulfilled", V8Value.class));
            JavetCallbackContext contextOnRejected = new JavetCallbackContext("onRejected", listener, listener.getClass().getMethod("onRejected", V8Value.class));
            try (V8ValueFunction functionOnCatch = this.v8Runtime.createV8ValueFunction(contextOnCatch);
                 V8ValueFunction functionOnFulfilled = this.v8Runtime.createV8ValueFunction(contextOnFulfilled);
                 V8ValueFunction functionOnRejected = this.v8Runtime.createV8ValueFunction(contextOnRejected);
                 V8ValuePromise v8ValuePromise = this.getPromise();){
                V8ValuePromise innerV8ValuePromise = v8ValuePromise.then(functionOnFulfilled, functionOnRejected);
                Throwable throwable = null;
                if (innerV8ValuePromise != null) {
                    if (throwable != null) {
                        try {
                            innerV8ValuePromise.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        innerV8ValuePromise.close();
                    }
                }
                innerV8ValuePromise = v8ValuePromise._catch(functionOnCatch);
                throwable = null;
                if (innerV8ValuePromise != null) {
                    if (throwable != null) {
                        try {
                            innerV8ValuePromise.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        innerV8ValuePromise.close();
                    }
                }
            }
            return true;
        }
        catch (Throwable t) {
            this.v8Runtime.getLogger().error("Failed to register a listener to a promise.", t);
            return false;
        }
    }

    @Override
    public boolean reject(V8Value v8Value) throws JavetException {
        return this.checkV8Runtime().getV8Internal().promiseReject(this, v8Value);
    }

    @Override
    public boolean resolve(V8Value v8Value) throws JavetException {
        return this.checkV8Runtime().getV8Internal().promiseResolve(this, v8Value);
    }

    @Override
    public V8ValuePromise then(IV8ValueFunction functionFulfilled, IV8ValueFunction functionRejected) throws JavetException {
        return this.checkV8Runtime().getV8Internal().promiseThen(this, functionFulfilled, functionRejected);
    }
}

