/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.utils;

import java.util.Objects;
import java.util.StringJoiner;

public final class JavetStringUtils {
    private JavetStringUtils() {
    }

    public static boolean isDigital(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String join(CharSequence delimiter, CharSequence ... elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        StringJoiner stringJoiner = new StringJoiner(delimiter);
        for (CharSequence cs : elements) {
            stringJoiner.add(cs);
        }
        return stringJoiner.toString();
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        StringJoiner stringJoiner = new StringJoiner(delimiter);
        for (CharSequence charSequence : elements) {
            stringJoiner.add(charSequence);
        }
        return stringJoiner.toString();
    }
}

