/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.converters;

import com.caoccao.javet.exceptions.JavetConverterException;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.converters.IJavetConverter;
import com.caoccao.javet.interop.converters.JavetConverterConfig;
import com.caoccao.javet.values.V8Value;
import java.util.Objects;

public abstract class BaseJavetConverter
implements IJavetConverter {
    protected JavetConverterConfig<?> config = new JavetConverterConfig();

    @Override
    public JavetConverterConfig<?> getConfig() {
        return this.config;
    }

    public void setConfig(JavetConverterConfig<?> config) {
        this.config = Objects.requireNonNull(config);
    }

    @Override
    public final <T> T toObject(V8Value v8Value) throws JavetException {
        return this.toObject(v8Value, 0);
    }

    protected abstract <T> T toObject(V8Value var1, int var2) throws JavetException;

    @Override
    public final <T extends V8Value> T toV8Value(V8Runtime v8Runtime, Object object) throws JavetException {
        return this.toV8Value(v8Runtime, object, 0);
    }

    protected abstract <T extends V8Value> T toV8Value(V8Runtime var1, Object var2, int var3) throws JavetException;

    protected void validateDepth(int depth) throws JavetException {
        if (depth >= this.config.getMaxDepth()) {
            throw JavetConverterException.circularStructure(this.config.getMaxDepth());
        }
    }
}

