/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.spi;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.metadata.method.IndexedPropertyMethodMetadata;
import com.buschmais.xo.api.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.api.metadata.type.EntityTypeMetadata;
import com.buschmais.xo.api.metadata.type.TypeMetadata;
import com.buschmais.xo.neo4j.api.model.Neo4jLabel;
import com.buschmais.xo.neo4j.api.model.Neo4jRelationshipType;
import com.buschmais.xo.neo4j.spi.Neo4jDatastore;
import com.buschmais.xo.neo4j.spi.Neo4jDatastoreSession;
import com.buschmais.xo.neo4j.spi.metadata.IndexedPropertyMetadata;
import com.buschmais.xo.neo4j.spi.metadata.NodeMetadata;
import com.buschmais.xo.neo4j.spi.metadata.PropertyMetadata;
import com.buschmais.xo.spi.datastore.DatastoreTransaction;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNeo4jDatastore<L extends Neo4jLabel, R extends Neo4jRelationshipType, DS extends Neo4jDatastoreSession>
implements Neo4jDatastore<L, R, DS> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNeo4jDatastore.class);

    public void init(Map<Class<?>, TypeMetadata> registeredMetadata) {
        HashSet<Neo4jDatastoreSession.Index> indexes = new HashSet<Neo4jDatastoreSession.Index>();
        for (TypeMetadata typeMetadata : registeredMetadata.values()) {
            if (!(typeMetadata instanceof EntityTypeMetadata)) continue;
            EntityTypeMetadata entityTypeMetadata = (EntityTypeMetadata)typeMetadata;
            Optional<Neo4jDatastoreSession.Index> labelIndex = this.getRequiredIndex(entityTypeMetadata, (IndexedPropertyMethodMetadata<IndexedPropertyMetadata>)entityTypeMetadata.getIndexedProperty());
            labelIndex.ifPresent(index -> indexes.add((Neo4jDatastoreSession.Index)index));
            this.getRequiredIndex(entityTypeMetadata, ((NodeMetadata)entityTypeMetadata.getDatastoreMetadata()).getUsingIndexedPropertyOf()).ifPresent(index -> indexes.add((Neo4jDatastoreSession.Index)index));
        }
        try (Neo4jDatastoreSession session = (Neo4jDatastoreSession)this.createSession();){
            DatastoreTransaction transaction = session.getDatastoreTransaction();
            transaction.begin();
            try {
                Set<Neo4jDatastoreSession.Index> existingIndexes = session.getIndexes();
                indexes.removeAll(existingIndexes);
                session.createIndexes(indexes);
                transaction.commit();
            }
            catch (XOException e) {
                transaction.rollback();
                throw e;
            }
        }
    }

    private Optional<Neo4jDatastoreSession.Index> getRequiredIndex(EntityTypeMetadata<NodeMetadata<L>> entityTypeMetadata, IndexedPropertyMethodMetadata<IndexedPropertyMetadata> indexedProperty) {
        if (indexedProperty != null) {
            Object label = ((NodeMetadata)entityTypeMetadata.getDatastoreMetadata()).getDiscriminator();
            PrimitivePropertyMethodMetadata propertyMethodMetadata = indexedProperty.getPropertyMethodMetadata();
            if (label != null && propertyMethodMetadata != null) {
                return Optional.of(Neo4jDatastoreSession.Index.builder().label(label.getName()).property(((PropertyMetadata)propertyMethodMetadata.getDatastoreMetadata()).getName()).build());
            }
        }
        return Optional.empty();
    }
}

