/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.impl.model;

import com.buschmais.xo.neo4j.api.model.Neo4jNode;
import com.buschmais.xo.neo4j.embedded.impl.model.AbstractEmbeddedPropertyContainer;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedDirection;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedLabel;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedRelationship;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedRelationshipType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class EmbeddedNode
extends AbstractEmbeddedPropertyContainer<Node>
implements Neo4jNode<EmbeddedLabel, EmbeddedRelationship, EmbeddedRelationshipType, EmbeddedDirection> {
    private final Set<EmbeddedLabel> labels = new HashSet<EmbeddedLabel>();

    public EmbeddedNode(Node delegate) {
        super(delegate.getId(), delegate);
        for (Label label : delegate.getLabels()) {
            this.labels.add(new EmbeddedLabel(label));
        }
    }

    public void delete() {
        ((Node)this.delegate).delete();
    }

    public Iterable<EmbeddedRelationship> getRelationships(EmbeddedRelationshipType type, EmbeddedDirection dir) {
        Iterable relationships = ((Node)this.delegate).getRelationships(type.getDelegate(), dir.getDelegate());
        return () -> {
            final Iterator iterator = relationships.iterator();
            return new Iterator<EmbeddedRelationship>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public EmbeddedRelationship next() {
                    return new EmbeddedRelationship((Relationship)iterator.next());
                }
            };
        };
    }

    public boolean hasRelationship(EmbeddedRelationshipType type, EmbeddedDirection dir) {
        return ((Node)this.delegate).hasRelationship(type.getDelegate(), dir.getDelegate());
    }

    public EmbeddedRelationship getSingleRelationship(EmbeddedRelationshipType type, EmbeddedDirection dir) {
        Relationship relationship = ((Node)this.delegate).getSingleRelationship(type.getDelegate(), dir.getDelegate());
        return relationship != null ? new EmbeddedRelationship(relationship) : null;
    }

    public EmbeddedRelationship createRelationshipTo(EmbeddedNode otherNode, EmbeddedRelationshipType type) {
        return new EmbeddedRelationship(((Node)this.delegate).createRelationshipTo((Node)otherNode.getDelegate(), type.getDelegate()));
    }

    public void addLabel(EmbeddedLabel label) {
        ((Node)this.delegate).addLabel(label.getDelegate());
        this.labels.add(label);
    }

    public void removeLabel(EmbeddedLabel label) {
        ((Node)this.delegate).removeLabel(label.getDelegate());
        this.labels.remove(label);
    }

    public Set<EmbeddedLabel> getLabels() {
        return this.labels;
    }
}

