/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.impl.datastore;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.spi.datastore.DatastoreTransaction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;

class EmbeddedDatastoreTransaction
implements DatastoreTransaction {
    private GraphDatabaseService graphDatabaseService;
    private Transaction transaction;

    public EmbeddedDatastoreTransaction(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
    }

    public void begin() {
        if (this.transaction != null) {
            throw new XOException("There is already an existing transaction.");
        }
        this.transaction = this.graphDatabaseService.beginTx();
    }

    public void commit() {
        this.ensureTransaction();
        this.transaction.success();
        this.closeTransaction();
    }

    public void rollback() {
        this.ensureTransaction();
        this.transaction.failure();
        this.closeTransaction();
    }

    public boolean isActive() {
        return this.transaction != null;
    }

    public Transaction getTransaction() {
        this.ensureTransaction();
        return this.transaction;
    }

    private void ensureTransaction() {
        if (this.transaction == null) {
            throw new XOException("There is no active transaction.");
        }
    }

    private void closeTransaction() {
        this.transaction.close();
        this.transaction = null;
    }
}

