/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.impl.datastore;

import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.api.annotation.Cypher;
import com.buschmais.xo.neo4j.embedded.impl.datastore.EmbeddedDatastoreSessionImpl;
import com.buschmais.xo.spi.datastore.DatastoreQuery;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Result;

public class EmbeddedCypherQuery
implements DatastoreQuery<Cypher> {
    private EmbeddedDatastoreSessionImpl embeddedNeo4jDatastoreSession;

    public EmbeddedCypherQuery(EmbeddedDatastoreSessionImpl embeddedNeo4jDatastoreSession) {
        this.embeddedNeo4jDatastoreSession = embeddedNeo4jDatastoreSession;
    }

    public ResultIterator<Map<String, Object>> execute(Cypher expression, Map<String, Object> parameters) {
        return this.execute(expression.value(), parameters);
    }

    public ResultIterator<Map<String, Object>> execute(String expression, Map<String, Object> parameters) {
        Map convertedParameters = (Map)this.embeddedNeo4jDatastoreSession.convertParameter(parameters);
        final Result executionResult = this.embeddedNeo4jDatastoreSession.getGraphDatabaseService().execute(expression, convertedParameters);
        final List columns = executionResult.columns();
        return new ResultIterator<Map<String, Object>>(){

            public boolean hasNext() {
                return executionResult.hasNext();
            }

            public Map<String, Object> next() {
                Map next = executionResult.next();
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(next.size(), 1.0f);
                for (String column : columns) {
                    result.put(column, EmbeddedCypherQuery.this.embeddedNeo4jDatastoreSession.convertValue(next.get(column)));
                }
                return result;
            }

            public void remove() {
                throw new XOException("Remove operation is not supported for query results.");
            }

            public void close() {
                executionResult.close();
            }
        };
    }
}

