/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.api;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.bootstrap.XOUnit;
import com.buschmais.xo.neo4j.embedded.api.DatastoreFactory;
import com.buschmais.xo.spi.bootstrap.XODatastoreProvider;
import com.buschmais.xo.spi.datastore.Datastore;
import com.google.common.base.CaseFormat;
import java.net.MalformedURLException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedNeo4jXOProvider
implements XODatastoreProvider {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedNeo4jXOProvider.class);

    public Datastore<?, ?, ?, ?, ?> createDatastore(XOUnit xoUnit) {
        URI uri = xoUnit.getUri();
        DatastoreFactory datastoreFactory = this.lookupFactory(uri);
        try {
            return datastoreFactory.createGraphDatabaseService(uri, xoUnit.getProperties());
        }
        catch (MalformedURLException e) {
            throw new XOException("Cannot create datastore.", (Throwable)e);
        }
    }

    DatastoreFactory lookupFactory(URI uri) {
        String factoryClass = this.getFactoryClassName(uri);
        LOG.debug("try to lookup provider-class {}", (Object)factoryClass);
        try {
            return (DatastoreFactory)Class.forName(factoryClass).newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new XOException("Cannot create datastore factory.", (Throwable)e);
        }
    }

    private String getFactoryClassName(URI uri) {
        String protocol = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, uri.getScheme());
        return DatastoreFactory.class.getPackage().getName() + "." + protocol + "DatastoreFactory";
    }

    public Class<? extends Enum<? extends XODatastoreProvider.ConfigurationProperty>> getConfigurationProperties() {
        return null;
    }
}

