/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.api.bootstrap.osgi;

import com.buschmais.xo.api.CloseAdapter;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.XOManagerFactory;
import com.buschmais.xo.api.bootstrap.XOBootstrapService;
import com.buschmais.xo.api.bootstrap.XOUnit;
import com.buschmais.xo.api.bootstrap.osgi.OSGiUtil;
import java.util.Collection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class XOSGi {
    public static XOManagerFactory createXOManagerFactory(String name) {
        if (OSGiUtil.isXOLoadedAsOSGiBundle()) {
            try {
                final BundleContext bundleContext = FrameworkUtil.getBundle(XOSGi.class).getBundleContext();
                String filterString = "(name=" + name + ")";
                Collection xoManagerFactoryServices = bundleContext.getServiceReferences(XOManagerFactory.class, filterString);
                for (final ServiceReference xoManagerFactoryService : xoManagerFactoryServices) {
                    XOManagerFactory xoManagerFactory = (XOManagerFactory)bundleContext.getService(xoManagerFactoryService);
                    if (xoManagerFactory == null) continue;
                    xoManagerFactory.addCloseListener(new CloseAdapter(){

                        @Override
                        public void onAfterClose() {
                            bundleContext.ungetService(xoManagerFactoryService);
                        }
                    });
                    return xoManagerFactory;
                }
            }
            catch (InvalidSyntaxException e) {
                throw new XOException("Cannot bootstrap XO implementation.", e);
            }
        }
        throw new XOException("Cannot bootstrap XO implementation.");
    }

    public static XOManagerFactory createXOManagerFactory(XOUnit xoUnit) {
        if (OSGiUtil.isXOLoadedAsOSGiBundle()) {
            BundleContext bundleContext = FrameworkUtil.getBundle(XOSGi.class).getBundleContext();
            ServiceReference xoBootstrapServiceReference = bundleContext.getServiceReference(XOBootstrapService.class);
            if (xoBootstrapServiceReference == null) {
                throw new XOException("Cannot bootstrap XO implementation.");
            }
            XOBootstrapService xoBootstrapService = (XOBootstrapService)bundleContext.getService(xoBootstrapServiceReference);
            if (xoBootstrapService == null) {
                throw new XOException("Cannot bootstrap XO implementation.");
            }
            XOManagerFactory xoManagerFactory = xoBootstrapService.createXOManagerFactory(xoUnit);
            bundleContext.ungetService(xoBootstrapServiceReference);
            if (xoManagerFactory != null) {
                return xoManagerFactory;
            }
        }
        throw new XOException("Cannot bootstrap XO implementation.");
    }
}

