/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileContainerDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractFileResolver;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerFileResolver
extends AbstractFileResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerFileResolver.class);
    private Map<String, FileDescriptor> requiredFiles;
    private Map<String, FileDescriptor> containedFiles;
    private FileContainerDescriptor fileContainerDescriptor;

    public ContainerFileResolver(FileContainerDescriptor fileContainerDescriptor) {
        this.fileContainerDescriptor = fileContainerDescriptor;
        this.containedFiles = this.getCache(fileContainerDescriptor.getContains());
        this.requiredFiles = this.getCache(fileContainerDescriptor.getRequires());
    }

    @Override
    public <D extends FileDescriptor> D require(String requiredPath, String containedPath, Class<D> type, ScannerContext context) {
        D result;
        FileDescriptor fileDescriptor = this.containedFiles.get(containedPath);
        if (fileDescriptor != null) {
            result = this.getOrCreateAs(containedPath, type, path -> fileDescriptor, context);
            this.containedFiles.put(containedPath, (FileDescriptor)result);
        } else {
            result = this.getOrCreateAs(containedPath, type, path -> this.requiredFiles.get(containedPath), context);
            this.requiredFiles.put(containedPath, (FileDescriptor)result);
        }
        return result;
    }

    @Override
    public <D extends FileDescriptor> D match(String containedPath, Class<D> type, ScannerContext context) {
        FileDescriptor fileDescriptor = this.requiredFiles.remove(containedPath);
        return this.getOrCreateAs(containedPath, type, path -> fileDescriptor, context);
    }

    public void flush() {
        this.createHierarchy();
        this.sync(this.fileContainerDescriptor.getRequires(), this.requiredFiles);
        this.sync(this.fileContainerDescriptor.getContains(), this.containedFiles);
    }

    private void sync(Collection<FileDescriptor> target, Map<String, FileDescriptor> after) {
        Map<String, FileDescriptor> before = this.getCache(target);
        HashMap<String, FileDescriptor> all = new HashMap<String, FileDescriptor>();
        all.putAll(before);
        all.putAll(after);
        for (Map.Entry entry : all.entrySet()) {
            String key = (String)entry.getKey();
            FileDescriptor fileDescriptor = (FileDescriptor)entry.getValue();
            boolean hasBefore = before.containsKey(key);
            boolean hasAfter = after.containsKey(key);
            if (hasBefore && !hasAfter) {
                target.remove(fileDescriptor);
                continue;
            }
            if (hasBefore || !hasAfter) continue;
            target.add(fileDescriptor);
        }
    }

    private Map<String, FileDescriptor> getCache(Iterable<FileDescriptor> fileDescriptors) {
        HashMap<String, FileDescriptor> cache = new HashMap<String, FileDescriptor>();
        for (Descriptor descriptor : fileDescriptors) {
            if (descriptor instanceof FileDescriptor) {
                FileDescriptor fileDescriptor = (FileDescriptor)descriptor;
                cache.put(fileDescriptor.getFileName(), fileDescriptor);
                continue;
            }
            LOGGER.warn("{} is not a file descriptor, container={}", (Object)descriptor, (Object)this.fileContainerDescriptor);
        }
        return cache;
    }

    private void createHierarchy() {
        for (Map.Entry<String, FileDescriptor> entry : this.containedFiles.entrySet()) {
            String parentName;
            FileDescriptor parentDescriptor;
            String relativePath = entry.getKey();
            FileDescriptor fileDescriptor = entry.getValue();
            int separatorIndex = relativePath.lastIndexOf(47);
            if (separatorIndex == -1 || !((parentDescriptor = this.containedFiles.get(parentName = relativePath.substring(0, separatorIndex))) instanceof FileContainerDescriptor)) continue;
            ((FileContainerDescriptor)((Object)parentDescriptor)).getContains().add(fileDescriptor);
        }
    }

    public void put(String path, FileDescriptor fileDescriptor) {
        this.containedFiles.put(path, fileDescriptor);
    }

    public int size() {
        return this.containedFiles.size();
    }
}

