/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalyzerConfiguration;
import com.buschmais.jqassistant.core.analysis.api.AnalyzerContext;
import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.RuleInterpreterPlugin;
import com.buschmais.jqassistant.core.analysis.api.model.ConceptDescriptor;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.Executable;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.Parameter;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleException;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.api.rule.Verification;
import com.buschmais.jqassistant.core.analysis.impl.AggregationVerificationStrategy;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerContextImpl;
import com.buschmais.jqassistant.core.analysis.impl.RowCountVerificationStrategy;
import com.buschmais.jqassistant.core.analysis.impl.VerificationStrategy;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.rule.api.executor.AbstractRuleVisitor;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.xo.api.XOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class AnalyzerVisitor
extends AbstractRuleVisitor {
    private AnalyzerConfiguration configuration;
    private Map<String, String> ruleParameters;
    private ReportPlugin reportPlugin;
    private AnalyzerContext analyzerContext;
    private Map<String, Collection<RuleInterpreterPlugin>> ruleInterpreterPlugins;

    AnalyzerVisitor(AnalyzerConfiguration configuration, Map<String, String> ruleParameters, Store store, Map<String, Collection<RuleInterpreterPlugin>> ruleInterpreterPlugins, ReportPlugin reportPlugin, Logger log) {
        this.configuration = configuration;
        this.ruleParameters = ruleParameters;
        this.ruleInterpreterPlugins = ruleInterpreterPlugins;
        this.reportPlugin = reportPlugin;
        this.analyzerContext = new AnalyzerContextImpl(store, log, this.initVerificationStrategies());
    }

    private Map<Class<? extends Verification>, VerificationStrategy> initVerificationStrategies() {
        HashMap<Class<? extends Verification>, VerificationStrategy> verificationStrategies = new HashMap<Class<? extends Verification>, VerificationStrategy>();
        RowCountVerificationStrategy rowCountVerificationStrategy = new RowCountVerificationStrategy();
        verificationStrategies.put(rowCountVerificationStrategy.getVerificationType(), rowCountVerificationStrategy);
        AggregationVerificationStrategy aggregationVerificationStrategy = new AggregationVerificationStrategy();
        verificationStrategies.put(aggregationVerificationStrategy.getVerificationType(), aggregationVerificationStrategy);
        return verificationStrategies;
    }

    public boolean visitConcept(Concept concept, Severity effectiveSeverity) throws RuleException {
        try {
            Result.Status status;
            this.analyzerContext.getStore().beginTransaction();
            ConceptDescriptor conceptDescriptor = (ConceptDescriptor)this.analyzerContext.getStore().find(ConceptDescriptor.class, concept.getId());
            if (conceptDescriptor == null || this.configuration.isExecuteAppliedConcepts()) {
                this.analyzerContext.getLogger().info("Applying concept '" + concept.getId() + "' with severity: '" + concept.getSeverity().getInfo(effectiveSeverity) + "'.");
                this.reportPlugin.beginConcept(concept);
                Result<Concept> result = this.execute(concept, effectiveSeverity);
                this.reportPlugin.setResult(result);
                status = result.getStatus();
                if (conceptDescriptor == null) {
                    conceptDescriptor = (ConceptDescriptor)this.analyzerContext.getStore().create(ConceptDescriptor.class);
                    conceptDescriptor.setId(concept.getId());
                    conceptDescriptor.setStatus(status);
                }
                this.reportPlugin.endConcept();
            } else {
                status = conceptDescriptor.getStatus();
            }
            this.analyzerContext.getStore().commitTransaction();
            return Result.Status.SUCCESS.equals((Object)status);
        }
        catch (XOException e) {
            this.analyzerContext.getStore().rollbackTransaction();
            throw new RuleException("Cannot apply concept " + concept.getId(), (Throwable)e);
        }
    }

    public void skipConcept(Concept concept, Severity effectiveSeverity) throws RuleException {
        this.analyzerContext.getStore().beginTransaction();
        this.reportPlugin.beginConcept(concept);
        Result result = Result.builder().rule((ExecutableRule)concept).status(Result.Status.SKIPPED).severity(effectiveSeverity).build();
        this.reportPlugin.setResult(result);
        this.reportPlugin.endConcept();
        this.analyzerContext.getStore().commitTransaction();
    }

    public void visitConstraint(Constraint constraint, Severity effectiveSeverity) throws RuleException {
        this.analyzerContext.getLogger().info("Validating constraint '" + constraint.getId() + "' with severity: '" + constraint.getSeverity().getInfo(effectiveSeverity) + "'.");
        try {
            this.analyzerContext.getStore().beginTransaction();
            this.reportPlugin.beginConstraint(constraint);
            this.reportPlugin.setResult(this.execute(constraint, effectiveSeverity));
            this.reportPlugin.endConstraint();
            this.analyzerContext.getStore().commitTransaction();
        }
        catch (XOException e) {
            this.analyzerContext.getStore().rollbackTransaction();
            throw new RuleException("Cannot validate constraint " + constraint.getId(), (Throwable)e);
        }
    }

    public void skipConstraint(Constraint constraint, Severity effectiveSeverity) throws RuleException {
        this.analyzerContext.getStore().beginTransaction();
        this.reportPlugin.beginConstraint(constraint);
        Result result = Result.builder().rule((ExecutableRule)constraint).status(Result.Status.SKIPPED).severity(effectiveSeverity).build();
        this.reportPlugin.setResult(result);
        this.reportPlugin.endConstraint();
        this.analyzerContext.getStore().commitTransaction();
    }

    public void beforeGroup(Group group, Severity effectiveSeverity) throws RuleException {
        this.analyzerContext.getLogger().info("Executing group '" + group.getId() + "'");
        this.analyzerContext.getStore().beginTransaction();
        this.reportPlugin.beginGroup(group);
        this.analyzerContext.getStore().commitTransaction();
    }

    public void afterGroup(Group group) throws RuleException {
        this.analyzerContext.getStore().beginTransaction();
        this.reportPlugin.endGroup();
        this.analyzerContext.getStore().commitTransaction();
    }

    private <T extends ExecutableRule> Result<T> execute(T executableRule, Severity severity) throws RuleException {
        Map<String, Object> ruleParameters = this.getRuleParameters(executableRule);
        Executable executable = executableRule.getExecutable();
        Collection<RuleInterpreterPlugin> languagePlugins = this.ruleInterpreterPlugins.get(executable.getLanguage());
        if (languagePlugins == null) {
            throw new RuleException("Could not determine plugin to execute " + executableRule);
        }
        for (RuleInterpreterPlugin languagePlugin : languagePlugins) {
            Result<T> result;
            if (!languagePlugin.accepts(executableRule) || (result = languagePlugin.execute(executableRule, ruleParameters, severity, this.analyzerContext)) == null) continue;
            return result;
        }
        throw new RuleException("No plugin for language '" + executable.getLanguage() + "' returned a result for " + executableRule);
    }

    private Map<String, Object> getRuleParameters(ExecutableRule executableRule) throws RuleException {
        HashMap<String, Object> ruleParameters = new HashMap<String, Object>();
        Map parameters = executableRule.getParameters();
        for (Map.Entry entry : parameters.entrySet()) {
            Object parameterValue;
            String parameterName = (String)entry.getKey();
            Parameter parameter = (Parameter)entry.getValue();
            String parameterValueAsString = this.ruleParameters.get(parameterName);
            if (parameterValueAsString != null) {
                try {
                    parameterValue = parameter.getType().parse(parameterValueAsString);
                }
                catch (RuleException e) {
                    throw new RuleException("Cannot determine value for parameter " + parameterName + "' of rule '" + executableRule + "'.");
                }
            } else {
                parameterValue = parameter.getDefaultValue();
            }
            if (parameterValue == null) {
                throw new RuleException("No value or default value defined for required parameter '" + parameterName + "' of rule '" + executableRule + "'.");
            }
            ruleParameters.put(parameterName, parameterValue);
        }
        return ruleParameters;
    }
}

