/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.Analyzer;
import com.buschmais.jqassistant.core.analysis.api.AnalyzerConfiguration;
import com.buschmais.jqassistant.core.analysis.api.RuleInterpreterPlugin;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleException;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSelection;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerVisitor;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.rule.api.executor.RuleSetExecutor;
import com.buschmais.jqassistant.core.rule.api.executor.RuleVisitor;
import com.buschmais.jqassistant.core.store.api.Store;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;

public class AnalyzerImpl
implements Analyzer {
    private final AnalyzerConfiguration configuration;
    private final Store store;
    private final Map<String, Collection<RuleInterpreterPlugin>> ruleInterpreterPlugins;
    private final ReportPlugin reportPlugin;
    private final Logger logger;

    public AnalyzerImpl(AnalyzerConfiguration configuration, Store store, Map<String, Collection<RuleInterpreterPlugin>> ruleInterpreterPlugins, ReportPlugin reportPlugin, Logger log) {
        this.configuration = configuration;
        this.store = store;
        this.ruleInterpreterPlugins = ruleInterpreterPlugins;
        this.reportPlugin = reportPlugin;
        this.logger = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RuleSet ruleSet, RuleSelection ruleSelection, Map<String, String> ruleParameters) throws RuleException {
        this.reportPlugin.begin();
        try {
            AnalyzerVisitor visitor = new AnalyzerVisitor(this.configuration, ruleParameters, this.store, this.ruleInterpreterPlugins, this.reportPlugin, this.logger);
            RuleSetExecutor executor = new RuleSetExecutor((RuleVisitor)visitor, this.configuration.getRuleSetExecutorConfiguration());
            executor.execute(ruleSet, ruleSelection);
        }
        finally {
            this.reportPlugin.end();
        }
    }
}

