/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalyzerContext;
import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleException;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.api.rule.Verification;
import com.buschmais.jqassistant.core.analysis.impl.VerificationStrategy;
import com.buschmais.jqassistant.core.rule.api.reader.RowCountVerification;
import com.buschmais.jqassistant.core.store.api.Store;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class AnalyzerContextImpl
implements AnalyzerContext {
    private static final Verification DEFAULT_VERIFICATION = RowCountVerification.builder().build();
    private Store store;
    private Logger logger;
    private Map<Class<? extends Verification>, VerificationStrategy> verificationStrategies;

    AnalyzerContextImpl(Store store, Logger logger, Map<Class<? extends Verification>, VerificationStrategy> verificationStrategies) {
        this.store = store;
        this.logger = logger;
        this.verificationStrategies = verificationStrategies;
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public <T extends ExecutableRule<?>> Result.Status verify(T executable, List<String> columnNames, List<Map<String, Object>> rows) throws RuleException {
        Verification verification = executable.getVerification();
        if (verification == null) {
            this.getLogger().debug("Using default verification for '{}'." + executable);
            verification = DEFAULT_VERIFICATION;
        }
        return this.verify(executable, columnNames, rows, verification);
    }

    @Override
    public <T extends ExecutableRule<?>> Result.Status verify(T executable, List<String> columnNames, List<Map<String, Object>> rows, Verification verification) throws RuleException {
        VerificationStrategy strategy = this.verificationStrategies.get(verification.getClass());
        if (strategy == null) {
            throw new RuleException("Result verification not supported: " + verification.getClass().getName());
        }
        return strategy.verify(executable, verification, columnNames, rows);
    }

    public <R extends ExecutableRule<?>> Result.ResultBuilder<R> resultBuilder(R rule, Severity severity) {
        return Result.builder().rule(rule).severity(severity);
    }
}

