/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AbstractRuleInterpreterPlugin;
import com.buschmais.jqassistant.core.analysis.api.AnalyzerContext;
import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleException;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.xo.api.Query;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractCypherRuleInterpreterPlugin
extends AbstractRuleInterpreterPlugin {
    protected <T extends ExecutableRule<?>> Result<T> execute(String cypher, T executableRule, Map<String, Object> parameters, Severity severity, AnalyzerContext context) throws RuleException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        context.getLogger().debug("Executing query '" + cypher + "' with parameters [" + parameters + "]");
        ArrayList columnNames = null;
        try (Query.Result compositeRowObjects = context.getStore().executeQuery(cypher, parameters);){
            for (Query.Result.CompositeRowObject rowObject : compositeRowObjects) {
                if (columnNames == null) {
                    columnNames = new ArrayList(rowObject.getColumns());
                }
                LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                for (String columnName : columnNames) {
                    row.put(columnName, rowObject.get(columnName, Object.class));
                }
                rows.add(row);
            }
        }
        catch (Exception e) {
            throw new RuleException("Cannot execute query for rule '" + executableRule + "'.", (Throwable)e);
        }
        Result.Status status = this.getStatus(executableRule, columnNames, rows, context);
        return Result.builder().rule(executableRule).status(status).severity(severity).columnNames(columnNames).rows(rows).build();
    }

    protected <T extends ExecutableRule<?>> Result.Status getStatus(T executableRule, List<String> columnNames, List<Map<String, Object>> rows, AnalyzerContext context) throws RuleException {
        return context.verify(executableRule, columnNames, rows);
    }
}

