/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxJSONObject;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;

public class BoxRecentItem
extends BoxJSONObject {
    private String type;
    private String interactionType;
    private BoxItem.Info item;
    private Date interactedAt;
    private URL interactionSharedLink;
    private BoxAPIConnection api;

    public BoxRecentItem(JsonObject jsonObject, BoxAPIConnection api) {
        super(jsonObject);
        this.api = api;
    }

    @Override
    protected void parseJSONMember(JsonObject.Member member) {
        block13: {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("type")) {
                    this.type = value.asString();
                } else if (memberName.equals("interaction_type")) {
                    this.interactionType = value.asString();
                } else if (memberName.equals("item")) {
                    String id = value.asObject().get("id").asString();
                    BoxFile boxFile = new BoxFile(this.api, id);
                    boxFile.getClass();
                    this.item = boxFile.new BoxFile.Info(value.asObject());
                } else if (memberName.equals("interacted_at")) {
                    this.interactedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("interaction_shared_link")) {
                    this.interactionSharedLink = new URL(value.asString());
                }
            }
            catch (ParseException e) {
                assert (false) : "A ParseException indicates a bug in the SDK.";
            }
            catch (MalformedURLException e) {
                if ($assertionsDisabled) break block13;
                throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public String getInteractionType() {
        return this.interactionType;
    }

    public BoxItem.Info getItem() {
        return this.item;
    }

    public Date getInteractedAt() {
        return this.interactedAt;
    }

    public URL getInteractionSharedLink() {
        return this.interactionSharedLink;
    }
}

