/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIResponse;
import com.eclipsesource.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class BoxAPIResponseException
extends BoxAPIException {
    private String message;
    private BoxAPIResponse responseObj;

    public BoxAPIResponseException(String message, BoxAPIResponse responseObj) {
        super(message, responseObj.getResponseCode(), responseObj.bodyToString());
        String requestId = "";
        String apiMessage = "";
        JsonObject responseJSON = null;
        this.responseObj = responseObj;
        TreeMap<String, List<String>> responseHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (String headerKey : responseObj.getHeaders().keySet()) {
            ArrayList<String> headerValues = new ArrayList<String>();
            headerValues.add(responseObj.getHeaderField(headerKey));
            responseHeaders.put(headerKey, headerValues);
        }
        this.setHeaders(responseHeaders);
        try {
            responseJSON = JsonObject.readFrom((String)responseObj.bodyToString());
            if (responseObj.bodyToString() != null && responseJSON.get("request_id") != null) {
                requestId = " | " + responseJSON.get("request_id").asString();
            }
            if (responseObj.bodyToString() != null && responseJSON.get("code") != null) {
                apiMessage = apiMessage + " " + responseJSON.get("code").asString();
            }
            if (responseObj.bodyToString() != null && responseJSON.get("message") != null) {
                apiMessage = apiMessage + " - " + responseJSON.get("message").asString();
            }
            this.setMessage(message + " [" + responseObj.getResponseCode() + requestId + "]" + apiMessage);
        }
        catch (Exception ex) {
            this.setMessage(message + " [" + responseObj.getResponseCode() + "]");
        }
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

