/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.querydsl;

import com.blazebit.persistence.BaseOngoingFinalSetOperationBuilder;
import com.blazebit.persistence.BaseOngoingSetOperationBuilder;
import com.blazebit.persistence.BaseSubqueryBuilder;
import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.DistinctBuilder;
import com.blazebit.persistence.FinalSetOperationCTECriteriaBuilder;
import com.blazebit.persistence.FinalSetOperationCriteriaBuilder;
import com.blazebit.persistence.FinalSetOperationSubqueryBuilder;
import com.blazebit.persistence.From;
import com.blazebit.persistence.FromBaseBuilder;
import com.blazebit.persistence.FromBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.FullSelectCTECriteriaBuilder;
import com.blazebit.persistence.GroupByBuilder;
import com.blazebit.persistence.HavingBuilder;
import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.LimitBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.OngoingSetOperationBuilder;
import com.blazebit.persistence.OrderByBuilder;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.Queryable;
import com.blazebit.persistence.SelectBaseCTECriteriaBuilder;
import com.blazebit.persistence.SelectBuilder;
import com.blazebit.persistence.SelectCTECriteriaBuilder;
import com.blazebit.persistence.SelectRecursiveCTECriteriaBuilder;
import com.blazebit.persistence.SetOperationBuilder;
import com.blazebit.persistence.StartOngoingSetOperationBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.WhereBuilder;
import com.blazebit.persistence.WindowBuilder;
import com.blazebit.persistence.WindowContainerBuilder;
import com.blazebit.persistence.WindowFrameBetweenBuilder;
import com.blazebit.persistence.WindowFrameBuilder;
import com.blazebit.persistence.WindowFrameExclusionBuilder;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.querydsl.AbstractBlazeJPAQuery;
import com.blazebit.persistence.querydsl.DefaultVisitorImpl;
import com.blazebit.persistence.querydsl.JPQLNextOps;
import com.blazebit.persistence.querydsl.JPQLNextSerializer;
import com.blazebit.persistence.querydsl.SetOperationFlag;
import com.blazebit.persistence.querydsl.ValuesExpression;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.querydsl.core.JoinExpression;
import com.querydsl.core.QueryFlag;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.BeanPath;
import com.querydsl.core.types.dsl.CollectionExpressionBase;
import com.querydsl.jpa.JPAQueryMixin;
import com.querydsl.jpa.JPQLSerializer;
import com.querydsl.jpa.JPQLTemplates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Attribute;

public class BlazeCriteriaBuilderRenderer<T> {
    private static final Logger LOG = Logger.getLogger(BlazeCriteriaBuilderRenderer.class.getName());
    private final CriteriaBuilderFactory criteriaBuilderFactory;
    private final EntityManager entityManager;
    private final JPQLNextSerializer serializer;
    private final Map<Object, String> constantToLabel = new IdentityHashMap<Object, String>();
    private Map<Expression<?>, String> subQueryToLabel = new IdentityHashMap();
    private final List<SubqueryInitiator<?>> subqueryInitiatorStack = new ArrayList();
    private List<Path<?>> cteAliases;
    private CriteriaBuilder<T> criteriaBuilder;

    public BlazeCriteriaBuilderRenderer(CriteriaBuilderFactory criteriaBuilderFactory, EntityManager entityManager, JPQLTemplates templates) {
        this.serializer = new JPQLNextExpressionSerializer(templates, entityManager);
        this.criteriaBuilderFactory = criteriaBuilderFactory;
        this.entityManager = entityManager;
    }

    public Queryable<T, ?> render(Expression<?> expression) {
        this.criteriaBuilder = this.criteriaBuilderFactory.create(this.entityManager, Object.class);
        return (Queryable)this.serializeSubQuery(this.criteriaBuilder, expression);
    }

    private Object serializeSubQuery(Object criteriaBuilder, Expression<?> expression) {
        Object result = expression.accept((Visitor)new Visitor<Object, Object>(){

            public Object visit(Constant<?> constant, Object criteriaBuilder) {
                throw new UnsupportedOperationException();
            }

            public Object visit(FactoryExpression<?> factoryExpression, Object criteriaBuilder) {
                throw new UnsupportedOperationException();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Object visit(Operation<?> setOperation, Object criteriaBuilder) {
                boolean lhsNestedSet;
                Expression lhs = setOperation.getArg(0);
                SubQueryExpression lhsSubquery = (SubQueryExpression)lhs.accept((Visitor)GetSubQueryVisitor.INSTANCE, null);
                SetOperationFlag setOperationFlag = lhsSubquery != null ? SetOperationFlag.getSetOperationFlag(lhsSubquery.getMetadata()) : null;
                boolean bl = lhsNestedSet = setOperationFlag != null && JPQLNextOps.LEFT_NESTED_SET_OPERATIONS.contains(setOperation.getOperator());
                if (lhsNestedSet) {
                    if (criteriaBuilder instanceof StartOngoingSetOperationBuilder) {
                        StartOngoingSetOperationBuilder ob = (StartOngoingSetOperationBuilder)criteriaBuilder;
                        criteriaBuilder = ob.startSet();
                    } else if (criteriaBuilder instanceof SubqueryInitiator) {
                        SubqueryInitiator subqueryInitiator = (SubqueryInitiator)criteriaBuilder;
                        criteriaBuilder = subqueryInitiator.startSet();
                    } else {
                        criteriaBuilder = BlazeCriteriaBuilderRenderer.this.criteriaBuilderFactory.startSet(BlazeCriteriaBuilderRenderer.this.entityManager, Object.class);
                    }
                    criteriaBuilder = setOperationFlag.getFlag().accept((Visitor)this, criteriaBuilder);
                    if (!(criteriaBuilder instanceof OngoingSetOperationBuilder)) throw new UnsupportedOperationException();
                    criteriaBuilder = ((OngoingSetOperationBuilder)criteriaBuilder).endSetWith();
                    BlazeCriteriaBuilderRenderer.this.renderOrderBy(lhsSubquery.getMetadata(), (OrderByBuilder)criteriaBuilder);
                    BlazeCriteriaBuilderRenderer.this.renderModifiers(lhsSubquery.getMetadata().getModifiers(), (LimitBuilder)criteriaBuilder);
                    criteriaBuilder = ((BaseOngoingFinalSetOperationBuilder)criteriaBuilder).endSet();
                } else {
                    criteriaBuilder = lhs.accept((Visitor)this, criteriaBuilder);
                }
                Expression rhs = setOperation.getArg(1);
                SubQueryExpression rhsSubquery = (SubQueryExpression)rhs.accept((Visitor)GetSubQueryVisitor.INSTANCE, null);
                setOperationFlag = rhsSubquery != null ? SetOperationFlag.getSetOperationFlag(rhsSubquery.getMetadata()) : null;
                boolean isNestedSet = setOperationFlag != null;
                SetOperationBuilder setOperationBuilder = (SetOperationBuilder)criteriaBuilder;
                switch ((JPQLNextOps)setOperation.getOperator()) {
                    case SET_UNION: 
                    case LEFT_NESTED_SET_UNION: {
                        criteriaBuilder = isNestedSet ? setOperationBuilder.startUnion() : setOperationBuilder.union();
                        break;
                    }
                    case SET_UNION_ALL: 
                    case LEFT_NESTED_SET_UNION_ALL: {
                        criteriaBuilder = isNestedSet ? setOperationBuilder.startUnionAll() : setOperationBuilder.unionAll();
                        break;
                    }
                    case SET_EXCEPT: 
                    case LEFT_NESTED_SET_EXCEPT: {
                        criteriaBuilder = isNestedSet ? setOperationBuilder.startExcept() : setOperationBuilder.except();
                        break;
                    }
                    case SET_EXCEPT_ALL: 
                    case LEFT_NESTED_SET_EXCEPT_ALL: {
                        criteriaBuilder = isNestedSet ? setOperationBuilder.startExceptAll() : setOperationBuilder.exceptAll();
                        break;
                    }
                    case SET_INTERSECT: 
                    case LEFT_NESTED_SET_INTERSECT: {
                        criteriaBuilder = isNestedSet ? setOperationBuilder.startIntersect() : setOperationBuilder.intersect();
                        break;
                    }
                    case SET_INTERSECT_ALL: 
                    case LEFT_NESTED_SET_INTERSECT_ALL: {
                        criteriaBuilder = isNestedSet ? setOperationBuilder.startIntersectAll() : setOperationBuilder.intersectAll();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("No support for set operation " + setOperation.getOperator());
                    }
                }
                if (!isNestedSet) return rhs.accept((Visitor)this, criteriaBuilder);
                criteriaBuilder = setOperationFlag.getFlag().accept((Visitor)this, criteriaBuilder);
                if (!(criteriaBuilder instanceof OngoingSetOperationBuilder)) throw new UnsupportedOperationException();
                criteriaBuilder = ((OngoingSetOperationBuilder)criteriaBuilder).endSetWith();
                BlazeCriteriaBuilderRenderer.this.renderOrderBy(rhsSubquery.getMetadata(), (OrderByBuilder)criteriaBuilder);
                BlazeCriteriaBuilderRenderer.this.renderModifiers(rhsSubquery.getMetadata().getModifiers(), (LimitBuilder)criteriaBuilder);
                return ((BaseOngoingFinalSetOperationBuilder)criteriaBuilder).endSet();
            }

            public Object visit(ParamExpression<?> paramExpression, Object criteriaBuilder) {
                throw new UnsupportedOperationException();
            }

            public Object visit(Path<?> path, Object criteriaBuilder) {
                throw new UnsupportedOperationException();
            }

            public Object visit(SubQueryExpression<?> subQuery, Object criteriaBuilder) {
                QueryMetadata subQueryMetadata = subQuery.getMetadata();
                SetOperationFlag setOperationFlag = SetOperationFlag.getSetOperationFlag(subQueryMetadata);
                if (setOperationFlag != null) {
                    return setOperationFlag.getFlag().accept((Visitor)this, criteriaBuilder);
                }
                BlazeCriteriaBuilderRenderer.this.renderCTEs(subQueryMetadata);
                criteriaBuilder = BlazeCriteriaBuilderRenderer.this.renderJoins(subQueryMetadata, (FromBaseBuilder)criteriaBuilder);
                criteriaBuilder = BlazeCriteriaBuilderRenderer.this.renderNamedWindows(subQueryMetadata, (WindowContainerBuilder)criteriaBuilder);
                BlazeCriteriaBuilderRenderer.this.renderDistinct(subQueryMetadata, (DistinctBuilder)criteriaBuilder);
                BlazeCriteriaBuilderRenderer.this.renderWhere(subQueryMetadata, (WhereBuilder)criteriaBuilder);
                BlazeCriteriaBuilderRenderer.this.renderGroupBy(subQueryMetadata, (GroupByBuilder)criteriaBuilder);
                BlazeCriteriaBuilderRenderer.this.renderHaving(subQueryMetadata, (HavingBuilder)criteriaBuilder);
                Expression select = subQueryMetadata.getProjection();
                if (select instanceof FactoryExpression && criteriaBuilder instanceof FullQueryBuilder) {
                    FactoryExpression factoryExpression = (FactoryExpression)select;
                    FullQueryBuilder fullQueryBuilder = (FullQueryBuilder)criteriaBuilder;
                    criteriaBuilder = fullQueryBuilder.selectNew((ObjectBuilder)new FactoryExpressionObjectBuilder(factoryExpression));
                } else {
                    List projection = BlazeCriteriaBuilderRenderer.this.expandProjection(subQueryMetadata.getProjection());
                    if (criteriaBuilder instanceof SelectBaseCTECriteriaBuilder) {
                        boolean bindEntity;
                        SelectBaseCTECriteriaBuilder selectBaseCriteriaBuilder = (SelectBaseCTECriteriaBuilder)criteriaBuilder;
                        boolean bl = bindEntity = projection.size() == 1 && ((Path)((JoinExpression)subQueryMetadata.getJoins().get(0)).getTarget().accept((Visitor)new JoinTargetAliasPathResolver(), null)).equals(projection.get(0));
                        if (bindEntity) {
                            EntityMetamodel metamodel = (EntityMetamodel)BlazeCriteriaBuilderRenderer.this.criteriaBuilderFactory.getService(EntityMetamodel.class);
                            Path pathExpression = (Path)projection.get(0);
                            ExtendedManagedType managedType = (ExtendedManagedType)metamodel.getManagedType(ExtendedManagedType.class, pathExpression.getType());
                            Map ownedSingularAttributes = managedType.getOwnedSingularAttributes();
                            for (Map.Entry ownedSingularAttribute : ownedSingularAttributes.entrySet()) {
                                String attributeName = (String)ownedSingularAttribute.getKey();
                                ExtendedAttribute attribute = (ExtendedAttribute)ownedSingularAttribute.getValue();
                                if (JpaMetamodelUtils.isAssociation((Attribute)attribute.getAttribute())) continue;
                                SelectBuilder bindBuilder = selectBaseCriteriaBuilder.bind(attributeName);
                                BeanPath beanPath = new BeanPath(attribute.getElementClass(), pathExpression, attributeName);
                                BlazeCriteriaBuilderRenderer.this.setExpressionSubqueries((Expression)beanPath, null, bindBuilder, SelectBuilderExpressionSetter.INSTANCE);
                            }
                        } else {
                            for (int i = 0; i < projection.size(); ++i) {
                                Operation projOperation;
                                Expression projExpression = (Expression)projection.get(i);
                                Path alias = null;
                                Path cteEntityPath = null;
                                if (projExpression instanceof Operation && (projOperation = (Operation)projExpression).getOperator() == JPQLNextOps.BIND) {
                                    alias = (Path)projOperation.getArg(1);
                                    cteEntityPath = alias.getRoot();
                                    projExpression = projOperation.getArg(0);
                                }
                                if (alias == null && BlazeCriteriaBuilderRenderer.this.cteAliases != null) {
                                    alias = (Path)BlazeCriteriaBuilderRenderer.this.cteAliases.get(i);
                                }
                                if (alias == null) {
                                    throw new UnsupportedOperationException("Select statement should be bound to any CTE attribute");
                                }
                                String aliasString = BlazeCriteriaBuilderRenderer.relativePathString(cteEntityPath, alias);
                                SelectBuilder bindBuilder = selectBaseCriteriaBuilder.bind(aliasString);
                                BlazeCriteriaBuilderRenderer.this.setExpressionSubqueries(projExpression, null, bindBuilder, SelectBuilderExpressionSetter.INSTANCE);
                            }
                        }
                    } else {
                        for (Expression selection : projection) {
                            BlazeCriteriaBuilderRenderer.this.renderSingleSelect(selection, (SelectBuilder)criteriaBuilder);
                        }
                    }
                }
                BlazeCriteriaBuilderRenderer.this.renderOrderBy(subQueryMetadata, (OrderByBuilder)criteriaBuilder);
                BlazeCriteriaBuilderRenderer.this.renderParameters(subQueryMetadata, (ParameterHolder)criteriaBuilder);
                BlazeCriteriaBuilderRenderer.this.renderConstants((ParameterHolder)criteriaBuilder);
                BlazeCriteriaBuilderRenderer.this.renderModifiers(subQueryMetadata.getModifiers(), (LimitBuilder)criteriaBuilder);
                return criteriaBuilder;
            }

            public Object visit(TemplateExpression<?> templateExpression, Object criteriaBuilder) {
                throw new UnsupportedOperationException();
            }
        }, criteriaBuilder);
        if (result instanceof BaseOngoingSetOperationBuilder) {
            result = ((BaseOngoingSetOperationBuilder)result).endSet();
        }
        if ((result instanceof FinalSetOperationCriteriaBuilder || result instanceof FinalSetOperationCTECriteriaBuilder || result instanceof FinalSetOperationSubqueryBuilder) && expression instanceof SubQueryExpression) {
            QueryMetadata metadata = ((SubQueryExpression)expression).getMetadata();
            this.renderOrderBy(metadata, (OrderByBuilder)result);
            this.renderModifiers(metadata.getModifiers(), (LimitBuilder)result);
        }
        return result;
    }

    private void renderCTEs(QueryMetadata subQueryMetadata) {
        for (QueryFlag queryFlag : subQueryMetadata.getFlags()) {
            Expression flag = queryFlag.getFlag();
            QueryFlag.Position position = queryFlag.getPosition();
            if (position != QueryFlag.Position.WITH) continue;
            flag.accept((Visitor)this.serializer, null);
        }
    }

    private <W extends WindowContainerBuilder<W>> W renderNamedWindows(QueryMetadata subQueryMetadata, W windowContainerBuilder) {
        for (QueryFlag queryFlag : subQueryMetadata.getFlags()) {
            Expression flag = queryFlag.getFlag();
            QueryFlag.Position position = queryFlag.getPosition();
            if (position != QueryFlag.Position.AFTER_HAVING) continue;
            windowContainerBuilder = this.renderWindowFlag(queryFlag, (WindowContainerBuilder)windowContainerBuilder);
        }
        return windowContainerBuilder;
    }

    private <X extends WindowContainerBuilder<X>> X renderWindowFlag(QueryFlag queryFlag, WindowContainerBuilder<X> windowContainerBuilder) {
        return (X)((WindowContainerBuilder)queryFlag.getFlag().accept(new WindowContainerBuilderDefaultVisitorImpl<X>(windowContainerBuilder), null));
    }

    private void renderModifiers(QueryModifiers modifiers, LimitBuilder<?> criteriaBuilder) {
        if (modifiers != null) {
            if (modifiers.getLimitAsInteger() != null) {
                criteriaBuilder.setMaxResults(modifiers.getLimitAsInteger().intValue());
            }
            if (modifiers.getOffsetAsInteger() != null) {
                criteriaBuilder.setFirstResult(modifiers.getOffsetAsInteger().intValue());
            }
        }
    }

    private void renderConstants(ParameterHolder<?> criteriaBuilder) {
        for (Map.Entry<Object, String> entry : this.constantToLabel.entrySet()) {
            criteriaBuilder.setParameter(entry.getValue(), entry.getKey());
        }
    }

    private void renderParameters(QueryMetadata metadata, ParameterHolder<?> criteriaBuilder) {
        for (Map.Entry entry : metadata.getParams().entrySet()) {
            criteriaBuilder.setParameter(((ParamExpression)entry.getKey()).getName(), entry.getValue());
        }
    }

    private void renderOrderBy(QueryMetadata metadata, OrderByBuilder<?> criteriaBuilder) {
        for (OrderSpecifier orderSpecifier : metadata.getOrderBy()) {
            this.renderOrderSpecifier(orderSpecifier, criteriaBuilder);
        }
    }

    private void renderHaving(QueryMetadata metadata, HavingBuilder<?> criteriaBuilder) {
        if (metadata.getHaving() != null) {
            this.setExpressionSubqueries((Expression<?>)metadata.getHaving(), null, (Object)criteriaBuilder, HavingBuilderExpressionSetter.INSTANCE);
        }
    }

    private void renderGroupBy(QueryMetadata metadata, GroupByBuilder<?> criteriaBuilder) {
        for (Expression groupByExpression : metadata.getGroupBy()) {
            criteriaBuilder.groupBy(this.renderExpression(groupByExpression));
        }
    }

    private void renderWhere(QueryMetadata metadata, WhereBuilder<?> criteriaBuilder) {
        if (metadata.getWhere() != null) {
            this.setExpressionSubqueries((Expression<?>)metadata.getWhere(), null, (Object)criteriaBuilder, WhereBuilderExpressionSetter.INSTANCE);
        }
    }

    private void renderDistinct(QueryMetadata metadata, DistinctBuilder<?> criteriaBuilder) {
        if (metadata.isDistinct()) {
            criteriaBuilder.distinct();
        }
    }

    private <X extends FromBuilder<X>> X renderJoins(QueryMetadata metadata, FromBaseBuilder<X> fromBuilder) {
        FromBuilder criteriaBuilder = null;
        block6: for (JoinExpression joinExpression : metadata.getJoins()) {
            Operation operation;
            boolean fetch = joinExpression.hasFlag(JPAQueryMixin.FETCH);
            boolean hasCondition = joinExpression.getCondition() != null;
            Expression target = joinExpression.getTarget();
            String alias = null;
            if (target instanceof Operation && (operation = (Operation)target).getOperator() == Ops.ALIAS) {
                target = operation.getArg(0);
                alias = ((Path)operation.getArg(1)).getMetadata().getName();
            }
            if (target instanceof ValuesExpression) {
                ValuesExpression valuesExpression = (ValuesExpression)target;
                Class type = valuesExpression.getRoot().getType();
                String name = valuesExpression.getAlias().getMetadata().getName();
                Collection elements = valuesExpression.getElements();
                if (!valuesExpression.getMetadata().isRoot()) {
                    String attribute = BlazeCriteriaBuilderRenderer.relativePathString(valuesExpression.getRoot(), valuesExpression);
                    if (valuesExpression.isIdentifiable()) {
                        criteriaBuilder = (FromBuilder)fromBuilder.fromIdentifiableValues(type, attribute, name, elements);
                        continue;
                    }
                    criteriaBuilder = (FromBuilder)fromBuilder.fromValues(type, attribute, name, elements);
                    continue;
                }
                if (valuesExpression.isIdentifiable()) {
                    criteriaBuilder = (FromBuilder)fromBuilder.fromIdentifiableValues(type, name, elements);
                    continue;
                }
                criteriaBuilder = (FromBuilder)fromBuilder.fromValues(type, name, elements);
                continue;
            }
            if (target instanceof Path) {
                Path entityPath = (Path)target;
                if (alias == null) {
                    alias = entityPath.getMetadata().getName();
                }
                boolean entityJoin = entityPath.getMetadata().isRoot();
                switch (joinExpression.getType()) {
                    case DEFAULT: {
                        From from;
                        if (fromBuilder instanceof FromBuilder && (from = (criteriaBuilder = (FromBuilder)fromBuilder).getFrom(alias)) != null) {
                            if (entityPath instanceof CollectionExpressionBase && ((CollectionExpressionBase)entityPath).getElementType().equals(from.getJavaType())) continue block6;
                            if (from.getJavaType().equals(entityPath.getType())) break;
                        }
                        if (entityJoin) {
                            criteriaBuilder = (FromBuilder)fromBuilder.from(entityPath.getType(), alias);
                            break;
                        }
                        String collectionExpression = this.renderExpression((Expression<?>)entityPath);
                        if (fromBuilder instanceof BaseSubqueryBuilder) {
                            criteriaBuilder = ((BaseSubqueryBuilder)fromBuilder).from(collectionExpression, alias);
                            break;
                        }
                        if (fromBuilder instanceof SubqueryInitiator) {
                            criteriaBuilder = ((SubqueryInitiator)fromBuilder).from(collectionExpression, alias);
                            break;
                        }
                        throw new IllegalArgumentException(collectionExpression + "  join not supported here");
                    }
                    default: {
                        JoinOnBuilder xJoinOnBuilder;
                        JoinType joinType = this.getJoinType(joinExpression);
                        if (hasCondition && fetch) {
                            LOG.warning("Fetch is ignored due to on-clause");
                        }
                        if (entityJoin) {
                            if (!hasCondition) {
                                throw new IllegalStateException("No on-clause for entity join!");
                            }
                            xJoinOnBuilder = criteriaBuilder.joinOn(entityPath.getType(), alias, joinType);
                            this.setExpressionSubqueries((Expression<?>)joinExpression.getCondition(), null, (Object)xJoinOnBuilder, JoinOnBuilderExpressionSetter.INSTANCE);
                            break;
                        }
                        if (!hasCondition) {
                            if (fetch) {
                                ((FullQueryBuilder)criteriaBuilder).joinDefault(this.renderExpression((Expression<?>)entityPath), alias, joinType, fetch);
                                break;
                            }
                            criteriaBuilder.joinDefault(this.renderExpression((Expression<?>)entityPath), alias, joinType);
                            break;
                        }
                        xJoinOnBuilder = criteriaBuilder.joinOn(this.renderExpression((Expression<?>)entityPath), alias, joinType);
                        this.setExpressionSubqueries((Expression<?>)joinExpression.getCondition(), null, (Object)xJoinOnBuilder, JoinOnBuilderExpressionSetter.INSTANCE);
                    }
                }
                continue;
            }
            if (target instanceof SubQueryExpression) {
                String subqueryAlias;
                switch (joinExpression.getType()) {
                    case DEFAULT: {
                        FullSelectCTECriteriaBuilder xFullSelectCTECriteriaBuilder = fromBuilder.fromSubquery(target.getType(), alias);
                        Object o = this.serializeSubQuery(xFullSelectCTECriteriaBuilder, target);
                        criteriaBuilder = o instanceof FinalSetOperationCTECriteriaBuilder ? (FromBuilder)((FinalSetOperationCTECriteriaBuilder)o).end() : (FromBuilder)((FullSelectCTECriteriaBuilder)o).end();
                        continue block6;
                    }
                }
                JoinType joinType = this.getJoinType(joinExpression);
                boolean isLateral = joinExpression.hasFlag(AbstractBlazeJPAQuery.LATERAL);
                if (fetch) {
                    LOG.warning("Fetch is ignored due to subquery entity join!");
                }
                SubQueryExpression subQueryExpression = (SubQueryExpression)target.accept((Visitor)new FirstSubqueryResolver(), null);
                Path fromPath = (Path)((JoinExpression)subQueryExpression.getMetadata().getJoins().get(0)).getTarget().accept((Visitor)new FirstSubqueryTargetPathResolver(), null);
                boolean entityJoin = fromPath.getMetadata().isRoot();
                if (hasCondition) {
                    FullSelectCTECriteriaBuilder joinOnBuilderFullSelectCTECriteriaBuilder;
                    if (isLateral) {
                        subqueryAlias = ((Path)((JoinExpression)subQueryExpression.getMetadata().getJoins().get(0)).getTarget().accept((Visitor)new JoinTargetAliasPathResolver(), null)).getMetadata().getName();
                        joinOnBuilderFullSelectCTECriteriaBuilder = entityJoin ? criteriaBuilder.joinLateralOnSubquery(target.getType(), alias, joinType) : criteriaBuilder.joinLateralOnSubquery(this.renderExpression((Expression<?>)fromPath), alias, subqueryAlias, joinType);
                    } else {
                        if (!entityJoin) {
                            throw new IllegalStateException("Entity join to association");
                        }
                        joinOnBuilderFullSelectCTECriteriaBuilder = criteriaBuilder.joinOnSubquery(target.getType(), alias, joinType);
                    }
                    Object o = this.serializeSubQuery(joinOnBuilderFullSelectCTECriteriaBuilder, target);
                    JoinOnBuilder joinOnBuilder = o instanceof FinalSetOperationCTECriteriaBuilder ? (JoinOnBuilder)((FinalSetOperationCTECriteriaBuilder)o).end() : (JoinOnBuilder)((FullSelectCTECriteriaBuilder)o).end();
                    criteriaBuilder = (FromBuilder)this.setExpressionSubqueries((Expression<?>)joinExpression.getCondition(), null, (Object)joinOnBuilder, JoinOnBuilderExpressionSetter.INSTANCE);
                    continue;
                }
                if (isLateral) {
                    subqueryAlias = ((Path)((JoinExpression)subQueryExpression.getMetadata().getJoins().get(0)).getTarget().accept((Visitor)new JoinTargetAliasPathResolver(), null)).getMetadata().getName();
                    FullSelectCTECriteriaBuilder xFullSelectCTECriteriaBuilder = entityJoin ? criteriaBuilder.joinLateralSubquery(target.getType(), alias, joinType) : criteriaBuilder.joinLateralSubquery(this.renderExpression((Expression<?>)fromPath), alias, subqueryAlias, joinType);
                    Object o = this.serializeSubQuery(xFullSelectCTECriteriaBuilder, target);
                    criteriaBuilder = o instanceof FinalSetOperationCTECriteriaBuilder ? (FromBuilder)((FinalSetOperationCTECriteriaBuilder)o).end() : (FromBuilder)((FullSelectCTECriteriaBuilder)o).end();
                    continue;
                }
                throw new IllegalStateException("No on-clause for subquery entity join!");
            }
            throw new UnsupportedOperationException("Joins for " + target + " is not yet implemented");
        }
        return (X)criteriaBuilder;
    }

    private List<? extends Expression<?>> expandProjection(Expression<?> expr) {
        if (expr instanceof FactoryExpression) {
            return ((FactoryExpression)expr).getArgs();
        }
        return Collections.singletonList(expr);
    }

    private JoinType getJoinType(JoinExpression joinExpression) {
        switch (joinExpression.getType()) {
            case INNERJOIN: 
            case JOIN: {
                return JoinType.INNER;
            }
            case LEFTJOIN: {
                return JoinType.LEFT;
            }
            case RIGHTJOIN: {
                return JoinType.RIGHT;
            }
            case FULLJOIN: {
                return JoinType.FULL;
            }
        }
        throw new IllegalArgumentException("Join has no equivalent JoinType");
    }

    private void renderOrderSpecifier(OrderSpecifier<?> orderSpecifier, OrderByBuilder<?> criteriaBuilder) {
        String orderExpression = this.renderExpression(orderSpecifier.getTarget());
        boolean ascending = orderSpecifier.isAscending();
        switch (orderSpecifier.getNullHandling()) {
            case Default: {
                criteriaBuilder.orderBy(orderExpression, ascending);
                break;
            }
            case NullsFirst: {
                criteriaBuilder.orderBy(orderExpression, ascending, true);
                break;
            }
            case NullsLast: {
                criteriaBuilder.orderBy(orderExpression, ascending, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Null handling not implemented for " + orderSpecifier.getNullHandling());
            }
        }
    }

    private void renderSingleSelect(Expression<?> select, SelectBuilder<?> selectBuilder) {
        Operation operation;
        String alias = null;
        if (select instanceof Operation && (operation = (Operation)select).getOperator() == Ops.ALIAS) {
            select = operation.getArg(0);
            alias = ((Path)operation.getArg(1)).getMetadata().getName();
        }
        this.setExpressionSubqueries(select, alias, selectBuilder, SelectBuilderExpressionSetter.INSTANCE);
    }

    private String renderExpression(Expression<?> select) {
        this.serializer.clearBuffer();
        select.accept((Visitor)this.serializer, null);
        return this.serializer.takeBuffer();
    }

    private void pushSubqueryInitiator(SubqueryInitiator<?> subqueryInitiator) {
        this.subqueryInitiatorStack.add(subqueryInitiator);
    }

    private void popSubqueryInitiator() {
        this.subqueryInitiatorStack.remove(this.subqueryInitiatorStack.size() - 1);
    }

    private Map<Expression<?>, String> takeSubQueryToLabelMap() {
        Map<Expression<?>, String> subQueryToLabel = this.subQueryToLabel;
        if (subQueryToLabel.isEmpty()) {
            return Collections.emptyMap();
        }
        this.subQueryToLabel = new IdentityHashMap();
        return subQueryToLabel;
    }

    private <B, X> X setExpressionSubqueries(Expression<?> expression, String alias, B builder, ExpressionSetter<B, X> expressionSetter) {
        String expressionString = this.renderExpression(expression);
        Map<Expression<?>, String> subQueryToLabel = this.takeSubQueryToLabelMap();
        if (subQueryToLabel.isEmpty()) {
            return expressionSetter.setExpression(builder, expressionString, alias);
        }
        MultipleSubqueryInitiator<X> subqueryInitiator = expressionSetter.setExpressionSubqueries(builder, expressionString, alias);
        for (Map.Entry<Expression<?>, String> entry : subQueryToLabel.entrySet()) {
            SubqueryInitiator initiator = subqueryInitiator.with(entry.getValue());
            this.pushSubqueryInitiator(initiator);
            Object o = this.serializeSubQuery(initiator, entry.getKey());
            if (o instanceof SubqueryBuilder) {
                o = ((SubqueryBuilder)o).end();
            } else if (o instanceof FinalSetOperationSubqueryBuilder) {
                o = ((FinalSetOperationSubqueryBuilder)o).end();
            }
            assert (subqueryInitiator == o) : "Expected SubqueryInitiator to return original MultipleSubqueryInitiator";
            this.popSubqueryInitiator();
        }
        return (X)subqueryInitiator.end();
    }

    private static String relativePathString(Path<?> root, Path<?> path) {
        StringBuilder pathString = new StringBuilder(path.getMetadata().getName().length());
        while (path.getMetadata().getParent() != null && !path.equals(root)) {
            if (pathString.length() > 0) {
                pathString.insert(0, '.');
            }
            pathString.insert(0, path.getMetadata().getName());
            path = path.getMetadata().getParent();
        }
        return pathString.toString();
    }

    public CriteriaBuilder<T> getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    private static interface ExpressionSetter<B, X> {
        public X setExpression(B var1, String var2, String var3);

        public MultipleSubqueryInitiator<? extends X> setExpressionSubqueries(B var1, String var2, String var3);
    }

    private class JPQLNextExpressionSerializer
    extends JPQLNextSerializer {
        private final JPQLTemplates templates;

        public JPQLNextExpressionSerializer(JPQLTemplates templates, EntityManager entityManager) {
            super(templates, entityManager);
            this.templates = templates;
        }

        public void visitConstant(Object constant) {
            boolean wrap = this.templates.wrapConstant(constant);
            if (wrap) {
                this.append("(");
            }
            this.append(":");
            String label = (String)BlazeCriteriaBuilderRenderer.this.constantToLabel.get(constant);
            if (label == null) {
                label = "param_" + BlazeCriteriaBuilderRenderer.this.constantToLabel.size();
                BlazeCriteriaBuilderRenderer.this.constantToLabel.put(constant, label);
            }
            this.append(label);
            if (wrap) {
                this.append(")");
            }
        }

        public Void visit(ParamExpression<?> param, Void context) {
            ((JPQLSerializer)this.append(":")).append(param.getName());
            return null;
        }

        @Override
        public Void visit(SubQueryExpression<?> query, Void context) {
            this.renderSubQueryExpression((Expression<?>)query);
            return null;
        }

        private void renderSubQueryExpression(Expression<?> query) {
            String label = (String)BlazeCriteriaBuilderRenderer.this.subQueryToLabel.get(query);
            if (label == null) {
                label = "generatedSubquery_" + (BlazeCriteriaBuilderRenderer.this.subQueryToLabel.size() + 1);
                BlazeCriteriaBuilderRenderer.this.subQueryToLabel.put(query, label);
            }
            BlazeCriteriaBuilderRenderer.this.serializer.append(label);
        }

        @Override
        protected void visitOperation(Class<?> type, Operator operator, List<? extends Expression<?>> args) {
            if (operator instanceof JPQLNextOps) {
                switch ((JPQLNextOps)operator) {
                    case WITH_RECURSIVE_ALIAS: 
                    case WITH_ALIAS: {
                        boolean recursive = operator == JPQLNextOps.WITH_RECURSIVE_ALIAS;
                        Expression<?> withColumns = args.get(0);
                        Expression<?> subQueryExpression = args.get(1);
                        withColumns.accept((Visitor)this, null);
                        Class cteType = withColumns.getType();
                        if (recursive) {
                            Operation unionOperation = (Operation)subQueryExpression.accept((Visitor)GetOperationVisitor.INSTANCE, null);
                            if (unionOperation == null) {
                                SubQueryExpression setSubquery = (SubQueryExpression)subQueryExpression.accept((Visitor)GetSubQueryVisitor.INSTANCE, null);
                                SetOperationFlag setFlag = SetOperationFlag.getSetOperationFlag(setSubquery.getMetadata());
                                unionOperation = (Operation)setFlag.getFlag().accept((Visitor)GetOperationVisitor.INSTANCE, null);
                            }
                            SubQueryExpression subQuery = (SubQueryExpression)unionOperation.getArg(0);
                            SelectRecursiveCTECriteriaBuilder baseCriteriaBuilder = (SelectRecursiveCTECriteriaBuilder)BlazeCriteriaBuilderRenderer.this.serializeSubQuery(BlazeCriteriaBuilderRenderer.this.criteriaBuilder.withRecursive(cteType), (Expression)subQuery);
                            SelectCTECriteriaBuilder recursiveCriteriaBuilder = unionOperation.getOperator() == JPQLNextOps.SET_UNION ? baseCriteriaBuilder.union() : baseCriteriaBuilder.unionAll();
                            subQuery = (SubQueryExpression)unionOperation.getArg(1);
                            ((SelectCTECriteriaBuilder)BlazeCriteriaBuilderRenderer.this.serializeSubQuery(recursiveCriteriaBuilder, (Expression)subQuery)).end();
                        } else {
                            FullSelectCTECriteriaBuilder cteBuilder = BlazeCriteriaBuilderRenderer.this.criteriaBuilder.with(cteType);
                            Object result = BlazeCriteriaBuilderRenderer.this.serializeSubQuery(cteBuilder, subQueryExpression);
                            if (result instanceof FinalSetOperationCTECriteriaBuilder) {
                                ((FinalSetOperationCTECriteriaBuilder)result).end();
                            } else if (result instanceof FullSelectCTECriteriaBuilder) {
                                ((FullSelectCTECriteriaBuilder)result).end();
                            }
                        }
                        return;
                    }
                    case WITH_RECURSIVE_COLUMNS: 
                    case WITH_COLUMNS: {
                        BlazeCriteriaBuilderRenderer.this.cteAliases = (List)args.get(1).accept((Visitor)new CteAttributesVisitor(), new ArrayList());
                        return;
                    }
                }
            }
            if (operator == Ops.EXISTS && args.get(0) instanceof SubQueryExpression) {
                this.append("EXISTS (");
                this.renderSubQueryExpression(args.get(0));
                this.append(")");
                return;
            }
            super.visitOperation(type, operator, args);
        }

        public Void visit(Operation<?> expr, Void context) {
            if (expr.getOperator() instanceof JPQLNextOps) {
                switch ((JPQLNextOps)expr.getOperator()) {
                    case SET_UNION: 
                    case LEFT_NESTED_SET_UNION: 
                    case SET_UNION_ALL: 
                    case LEFT_NESTED_SET_UNION_ALL: 
                    case SET_EXCEPT: 
                    case LEFT_NESTED_SET_EXCEPT: 
                    case SET_EXCEPT_ALL: 
                    case LEFT_NESTED_SET_EXCEPT_ALL: 
                    case SET_INTERSECT: 
                    case LEFT_NESTED_SET_INTERSECT: 
                    case SET_INTERSECT_ALL: 
                    case LEFT_NESTED_SET_INTERSECT_ALL: {
                        this.renderSubQueryExpression((Expression<?>)expr);
                        return null;
                    }
                }
            }
            return super.visit(expr, context);
        }
    }

    private class WindowContainerBuilderDefaultVisitorImpl<X extends WindowContainerBuilder<X>>
    extends DefaultVisitorImpl<X, Object> {
        private boolean between;
        private boolean frameStartMode;
        private final WindowContainerBuilder<X> windowContainerBuilder;
        private WindowBuilder<X> window;
        private WindowFrameBuilder<X> rows;
        private WindowFrameBetweenBuilder<X> windowFrameBetweenBuilder;
        private WindowFrameExclusionBuilder<X> windowFrameExclusionBuilder;

        public WindowContainerBuilderDefaultVisitorImpl(WindowContainerBuilder<X> windowContainerBuilder) {
            this.windowContainerBuilder = windowContainerBuilder;
            this.between = false;
            this.frameStartMode = true;
        }

        @Override
        public X visit(Operation<?> operation, Object o) {
            List arguments = operation.getArgs();
            if (operation.getOperator() instanceof JPQLNextOps) {
                switch ((JPQLNextOps)operation.getOperator()) {
                    case WINDOW_NAME: {
                        this.window = this.windowContainerBuilder.window(((Constant)arguments.get(0)).getConstant().toString());
                        ((Expression)arguments.get(1)).accept((Visitor)this, o);
                        break;
                    }
                    case WINDOW_BASE: {
                        throw new UnsupportedOperationException("Named window extension is not supported in WindowContainerBuilder");
                    }
                    case WINDOW_ORDER_BY: {
                        ((Expression)operation.getArgs().get(0)).accept((Visitor)new DefaultVisitorImpl<Object, Object>(){

                            @Override
                            public Object visit(Operation<?> operation, Object o) {
                                if (operation.getOperator() == Ops.LIST) {
                                    operation.getArg(0).accept((Visitor)this, null);
                                    operation.getArg(1).accept((Visitor)this, null);
                                    return null;
                                }
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public Object visit(TemplateExpression<?> templateExpression, Object o) {
                                String nullRendering = templateExpression.getArgs().get(2).toString();
                                if ("".equals(nullRendering)) {
                                    WindowContainerBuilderDefaultVisitorImpl.this.window = (WindowBuilder)WindowContainerBuilderDefaultVisitorImpl.this.window.orderBy(BlazeCriteriaBuilderRenderer.this.renderExpression((Expression)templateExpression.getArg(0)), templateExpression.getArg(1).equals(Order.ASC));
                                } else if ("NULLS FIRST".equals(nullRendering)) {
                                    WindowContainerBuilderDefaultVisitorImpl.this.window = (WindowBuilder)WindowContainerBuilderDefaultVisitorImpl.this.window.orderBy(BlazeCriteriaBuilderRenderer.this.renderExpression((Expression)templateExpression.getArg(0)), templateExpression.getArg(1).equals(Order.ASC), true);
                                } else {
                                    WindowContainerBuilderDefaultVisitorImpl.this.window = (WindowBuilder)WindowContainerBuilderDefaultVisitorImpl.this.window.orderBy(BlazeCriteriaBuilderRenderer.this.renderExpression((Expression)templateExpression.getArg(0)), templateExpression.getArg(1).equals(Order.ASC), false);
                                }
                                return null;
                            }
                        }, null);
                        break;
                    }
                    case WINDOW_PARTITION_BY: {
                        this.window = (WindowBuilder)((Expression)operation.getArgs().get(0)).accept(new Visitor<WindowBuilder<X>, WindowBuilder<X>>(){

                            public WindowBuilder<X> visit(Constant<?> expr, WindowBuilder<X> window) {
                                return window.partitionBy(BlazeCriteriaBuilderRenderer.this.renderExpression(expr));
                            }

                            public WindowBuilder<X> visit(FactoryExpression<?> expr, WindowBuilder<X> window) {
                                throw new UnsupportedOperationException();
                            }

                            public WindowBuilder<X> visit(Operation<?> operation, WindowBuilder<X> window) {
                                if (operation.getOperator() == Ops.LIST) {
                                    window = (WindowBuilder)operation.getArg(0).accept((Visitor)this, window);
                                    return (WindowBuilder)operation.getArg(1).accept((Visitor)this, (Object)window);
                                }
                                return window.partitionBy(BlazeCriteriaBuilderRenderer.this.renderExpression(operation));
                            }

                            public WindowBuilder<X> visit(ParamExpression<?> expr, WindowBuilder<X> window) {
                                return window.partitionBy(BlazeCriteriaBuilderRenderer.this.renderExpression(expr));
                            }

                            public WindowBuilder<X> visit(Path<?> expr, WindowBuilder<X> window) {
                                return window.partitionBy(BlazeCriteriaBuilderRenderer.this.renderExpression(expr));
                            }

                            public WindowBuilder<X> visit(SubQueryExpression<?> expr, WindowBuilder<X> window) {
                                return window.partitionBy(BlazeCriteriaBuilderRenderer.this.renderExpression(expr));
                            }

                            public WindowBuilder<X> visit(TemplateExpression<?> expr, WindowBuilder<X> window) {
                                return window.partitionBy(BlazeCriteriaBuilderRenderer.this.renderExpression(expr));
                            }
                        }, this.window);
                        break;
                    }
                    case WINDOW_ROWS: {
                        this.rows = this.window.rows();
                        ((Expression)arguments.get(0)).accept((Visitor)this, o);
                        break;
                    }
                    case WINDOW_RANGE: {
                        this.rows = this.window.range();
                        ((Expression)arguments.get(0)).accept((Visitor)this, o);
                        break;
                    }
                    case WINDOW_GROUPS: {
                        this.rows = this.window.groups();
                        ((Expression)arguments.get(0)).accept((Visitor)this, o);
                        break;
                    }
                    case WINDOW_BETWEEN: {
                        this.between = true;
                        ((Expression)arguments.get(0)).accept((Visitor)this, o);
                        ((Expression)arguments.get(1)).accept((Visitor)this, o);
                        break;
                    }
                    case WINDOW_UNBOUNDED_PRECEDING: {
                        assert (this.frameStartMode);
                        assert (this.rows != null);
                        if (this.between) {
                            this.windowFrameBetweenBuilder = this.rows.betweenUnboundedPreceding();
                        } else {
                            this.windowFrameExclusionBuilder = this.rows.unboundedPreceding();
                        }
                        this.frameStartMode = false;
                        break;
                    }
                    case WINDOW_PRECEDING: {
                        if (this.frameStartMode) {
                            assert (this.rows != null);
                            if (this.between) {
                                this.windowFrameBetweenBuilder = this.rows.betweenPreceding(BlazeCriteriaBuilderRenderer.this.renderExpression((Expression)arguments.get(0)));
                            } else {
                                this.windowFrameExclusionBuilder = this.rows.preceding(BlazeCriteriaBuilderRenderer.this.renderExpression((Expression)arguments.get(0)));
                            }
                            this.frameStartMode = false;
                        } else {
                            this.windowFrameExclusionBuilder = this.windowFrameBetweenBuilder.andPreceding(BlazeCriteriaBuilderRenderer.this.renderExpression((Expression)arguments.get(0)));
                        }
                        ((Expression)arguments.get(0)).accept((Visitor)this, o);
                        break;
                    }
                    case WINDOW_FOLLOWING: {
                        if (this.frameStartMode) {
                            assert (this.between);
                            assert (this.rows != null);
                            this.windowFrameBetweenBuilder = this.rows.betweenFollowing(BlazeCriteriaBuilderRenderer.this.renderExpression((Expression)arguments.get(0)));
                            this.frameStartMode = false;
                        } else {
                            this.windowFrameExclusionBuilder = this.windowFrameBetweenBuilder.andFollowing(BlazeCriteriaBuilderRenderer.this.renderExpression((Expression)arguments.get(0)));
                        }
                        ((Expression)arguments.get(0)).accept((Visitor)this, o);
                        break;
                    }
                    case WINDOW_UNBOUNDED_FOLLOWING: {
                        assert (!this.frameStartMode);
                        this.windowFrameExclusionBuilder = this.windowFrameBetweenBuilder.andUnboundedFollowing();
                        break;
                    }
                    case WINDOW_CURRENT_ROW: {
                        if (this.frameStartMode) {
                            assert (this.rows != null);
                            if (this.between) {
                                this.windowFrameBetweenBuilder = this.rows.betweenCurrentRow();
                            } else {
                                this.windowFrameExclusionBuilder = this.rows.currentRow();
                            }
                            this.frameStartMode = false;
                            break;
                        }
                        this.windowFrameExclusionBuilder = this.windowFrameBetweenBuilder.andCurrentRow();
                        break;
                    }
                    case WINDOW_DEFINITION_1: 
                    case WINDOW_DEFINITION_2: 
                    case WINDOW_DEFINITION_3: 
                    case WINDOW_DEFINITION_4: {
                        for (Expression argument : arguments) {
                            argument.accept((Visitor)this, o);
                        }
                        if (this.windowFrameExclusionBuilder != null) {
                            return (X)((WindowContainerBuilder)this.windowFrameExclusionBuilder.end());
                        }
                        return (X)((WindowContainerBuilder)this.window.end());
                    }
                }
            }
            return (X)this.windowContainerBuilder;
        }
    }

    private static class HavingBuilderExpressionSetter<X extends HavingBuilder<X>>
    implements ExpressionSetter<HavingBuilder<X>, X> {
        private static final HavingBuilderExpressionSetter INSTANCE = new HavingBuilderExpressionSetter();

        private HavingBuilderExpressionSetter() {
        }

        @Override
        public X setExpression(HavingBuilder<X> builder, String expression, String alias) {
            return (X)builder.setHavingExpression(expression);
        }

        @Override
        public MultipleSubqueryInitiator<? extends X> setExpressionSubqueries(HavingBuilder<X> builder, String expression, String alias) {
            return builder.setHavingExpressionSubqueries(expression);
        }
    }

    private static class WhereBuilderExpressionSetter<X extends WhereBuilder<X>>
    implements ExpressionSetter<WhereBuilder<X>, X> {
        private static final WhereBuilderExpressionSetter INSTANCE = new WhereBuilderExpressionSetter();

        private WhereBuilderExpressionSetter() {
        }

        @Override
        public X setExpression(WhereBuilder<X> builder, String expression, String alias) {
            return (X)builder.setWhereExpression(expression);
        }

        @Override
        public MultipleSubqueryInitiator<? extends X> setExpressionSubqueries(WhereBuilder<X> builder, String expression, String alias) {
            return builder.setWhereExpressionSubqueries(expression);
        }
    }

    private static class JoinOnBuilderExpressionSetter<X>
    implements ExpressionSetter<JoinOnBuilder<X>, X> {
        private static final JoinOnBuilderExpressionSetter INSTANCE = new JoinOnBuilderExpressionSetter();

        private JoinOnBuilderExpressionSetter() {
        }

        @Override
        public X setExpression(JoinOnBuilder<X> builder, String expression, String alias) {
            return (X)builder.setOnExpression(expression);
        }

        @Override
        public MultipleSubqueryInitiator<? extends X> setExpressionSubqueries(JoinOnBuilder<X> builder, String expression, String alias) {
            return builder.setOnExpressionSubqueries(expression);
        }
    }

    private static class FirstSubqueryResolver
    extends DefaultVisitorImpl<SubQueryExpression<?>, Object> {
        private FirstSubqueryResolver() {
        }

        @Override
        public SubQueryExpression<?> visit(Operation<?> operation, Object o) {
            return (SubQueryExpression)operation.getArg(0).accept((Visitor)this, o);
        }

        @Override
        public SubQueryExpression<?> visit(SubQueryExpression<?> subQueryExpression, Object o) {
            SetOperationFlag setOperationFlag = SetOperationFlag.getSetOperationFlag(subQueryExpression.getMetadata());
            if (setOperationFlag != null) {
                return (SubQueryExpression)setOperationFlag.getFlag().accept((Visitor)this, o);
            }
            return subQueryExpression;
        }
    }

    private static class FirstSubqueryTargetPathResolver
    extends DefaultVisitorImpl<Path<?>, Object> {
        private FirstSubqueryTargetPathResolver() {
        }

        @Override
        public Path<?> visit(Operation<?> operation, Object o) {
            return (Path)operation.getArg(0).accept((Visitor)this, o);
        }

        @Override
        public Path<?> visit(Path<?> path, Object o) {
            return path;
        }

        @Override
        public Path<?> visit(SubQueryExpression<?> subQueryExpression, Object o) {
            return (Path)((JoinExpression)subQueryExpression.getMetadata().getJoins().get(0)).getTarget().accept((Visitor)this, o);
        }
    }

    private static class JoinTargetAliasPathResolver
    extends DefaultVisitorImpl<Path<?>, Void> {
        private JoinTargetAliasPathResolver() {
        }

        @Override
        public Path<?> visit(Operation<?> operation, Void aVoid) {
            return (Path)operation.getArg(1).accept((Visitor)this, (Object)aVoid);
        }

        @Override
        public Path<?> visit(Path<?> path, Void aVoid) {
            return path;
        }
    }

    private static class SelectBuilderExpressionSetter<X>
    implements ExpressionSetter<SelectBuilder<X>, X> {
        private static final SelectBuilderExpressionSetter INSTANCE = new SelectBuilderExpressionSetter();

        private SelectBuilderExpressionSetter() {
        }

        @Override
        public X setExpression(SelectBuilder<X> builder, String expression, String alias) {
            return (X)(alias != null ? builder.select(expression, alias) : builder.select(expression));
        }

        @Override
        public MultipleSubqueryInitiator<? extends X> setExpressionSubqueries(SelectBuilder<X> builder, String expression, String alias) {
            return alias != null ? builder.selectSubqueries(expression, alias) : builder.selectSubqueries(expression);
        }
    }

    private static class GetSubQueryVisitor
    extends DefaultVisitorImpl<SubQueryExpression<?>, Void> {
        public static final GetSubQueryVisitor INSTANCE = new GetSubQueryVisitor();

        private GetSubQueryVisitor() {
        }

        @Override
        public SubQueryExpression<?> visit(SubQueryExpression<?> subQueryExpression, Void aVoid) {
            return subQueryExpression;
        }
    }

    private static class GetOperationVisitor
    extends DefaultVisitorImpl<Operation<?>, Void> {
        public static final GetOperationVisitor INSTANCE = new GetOperationVisitor();

        private GetOperationVisitor() {
        }

        @Override
        public Operation<?> visit(Operation<?> operation, Void aVoid) {
            return operation;
        }
    }

    private class FactoryExpressionObjectBuilder
    implements ObjectBuilder<T> {
        private final FactoryExpression<T> factoryExpression;

        public FactoryExpressionObjectBuilder(FactoryExpression<T> factoryExpression) {
            this.factoryExpression = factoryExpression;
        }

        public <X extends SelectBuilder<X>> void applySelects(X selectBuilder) {
            for (Expression arg : this.factoryExpression.getArgs()) {
                BlazeCriteriaBuilderRenderer.this.renderSingleSelect(arg, selectBuilder);
            }
        }

        public T build(Object[] tuple) {
            return this.factoryExpression.newInstance(tuple);
        }

        public List<T> buildList(List<T> list) {
            return list;
        }
    }

    private static class CteAttributesVisitor
    extends DefaultVisitorImpl<List<Path<?>>, List<Path<?>>> {
        private CteAttributesVisitor() {
        }

        @Override
        public List<Path<?>> visit(Operation<?> operation, List<Path<?>> cteAliases) {
            switch ((Ops)operation.getOperator()) {
                case SINGLETON: {
                    operation.getArg(0).accept((Visitor)this, cteAliases);
                    break;
                }
                case LIST: {
                    this.visit(operation.getArgs(), cteAliases);
                    break;
                }
            }
            return cteAliases;
        }

        @Override
        public List<Path<?>> visit(Path<?> expr, List<Path<?>> context) {
            context.add(expr);
            return context;
        }

        @Override
        private void visit(List<Expression<?>> exprs, List<Path<?>> context) {
            for (Expression<?> e : exprs) {
                e.accept((Visitor)this, context);
            }
        }
    }

    private static interface Function<T, R> {
        public R apply(T var1);
    }
}

