/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.AbstractExpressionFactoryMacroAdapter;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCache;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.MacroConfiguration;
import com.blazebit.persistence.parser.expression.MacroFunction;
import com.blazebit.persistence.parser.predicate.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractCachingExpressionFactory
extends AbstractExpressionFactoryMacroAdapter {
    private static final ExpressionSupplier PATH_EXPRESSION_SUPPLIER = new ExpressionSupplier(){

        @Override
        public Expression get(ExpressionFactory expressionFactory, String expression, boolean allowOuter, boolean allowQuantifiedPredicates, boolean allowObjectExpression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
            return expressionFactory.createPathExpression(expression, macroConfiguration, usedMacros);
        }
    };
    private static final ExpressionSupplier SIMPLE_EXPRESSION_SUPPLIER = new ExpressionSupplier(){

        @Override
        public Expression get(ExpressionFactory expressionFactory, String expression, boolean allowOuter, boolean allowQuantifiedPredicates, boolean allowObjectExpression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
            return expressionFactory.createSimpleExpression(expression, allowOuter, allowQuantifiedPredicates, allowObjectExpression, macroConfiguration, usedMacros);
        }
    };
    private static final ExpressionSupplier IN_ITEM_EXPRESSION_SUPPLIER = new ExpressionSupplier(){

        @Override
        public Expression get(ExpressionFactory expressionFactory, String expression, boolean allowOuter, boolean allowQuantifiedPredicates, boolean allowObjectExpression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
            return expressionFactory.createInItemExpression(expression, macroConfiguration, usedMacros);
        }
    };
    private static final ExpressionSupplier IN_ITEM_OR_PATH_EXPRESSION_SUPPLIER = new ExpressionSupplier(){

        @Override
        public Expression get(ExpressionFactory expressionFactory, String expression, boolean allowOuter, boolean allowQuantifiedPredicates, boolean allowObjectExpression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
            return expressionFactory.createInItemOrPathExpression(expression, macroConfiguration, usedMacros);
        }
    };
    private static final ExpressionSupplier BOOLEAN_EXPRESSION_SUPPLIER = new ExpressionSupplier(){

        @Override
        public Expression get(ExpressionFactory expressionFactory, String expression, boolean allowOuter, boolean allowQuantifiedPredicates, boolean allowObjectExpression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
            return expressionFactory.createBooleanExpression(expression, allowQuantifiedPredicates, macroConfiguration, usedMacros);
        }
    };
    private final ExpressionFactory delegate;
    private final ExpressionCache<ExpressionCacheEntry> expressionCache;

    public AbstractCachingExpressionFactory(ExpressionFactory delegate, ExpressionCache expressionCache) {
        this.delegate = delegate;
        this.expressionCache = expressionCache;
    }

    @Override
    public <T extends ExpressionFactory> T unwrap(Class<T> clazz) {
        if (AbstractCachingExpressionFactory.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        return this.delegate.unwrap(clazz);
    }

    @Override
    public MacroConfiguration getDefaultMacroConfiguration() {
        return this.delegate.getDefaultMacroConfiguration();
    }

    @Override
    public Expression createPathExpression(String expression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        return this.getOrDefault("com.blazebit.persistence.parser.expression.cache.PathExpression", this.delegate, expression, false, false, false, macroConfiguration, PATH_EXPRESSION_SUPPLIER);
    }

    @Override
    public Expression createSimpleExpression(String expression, boolean allowOuter, boolean allowQuantifiedPredicates, boolean allowObjectExpression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        return this.getOrDefault("com.blazebit.persistence.parser.expression.cache.SimpleExpression", this.delegate, expression, allowOuter, allowQuantifiedPredicates, allowObjectExpression, macroConfiguration, SIMPLE_EXPRESSION_SUPPLIER);
    }

    @Override
    public List<Expression> createInItemExpressions(String[] parameterOrLiteralExpressions, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        if (parameterOrLiteralExpressions == null) {
            throw new NullPointerException("parameterOrLiteralExpressions");
        }
        if (parameterOrLiteralExpressions.length == 0) {
            throw new IllegalArgumentException("empty parameterOrLiteralExpressions");
        }
        ArrayList<Expression> inItemExpressions = new ArrayList<Expression>();
        if (parameterOrLiteralExpressions.length == 1) {
            inItemExpressions.add(this.createInItemOrPathExpression(parameterOrLiteralExpressions[0], macroConfiguration, usedMacros));
        } else {
            for (String parameterOrLiteralExpression : parameterOrLiteralExpressions) {
                inItemExpressions.add(this.createInItemExpression(parameterOrLiteralExpression, macroConfiguration, usedMacros));
            }
        }
        return inItemExpressions;
    }

    @Override
    public Expression createInItemExpression(String parameterOrLiteralExpression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        return this.getOrDefault("com.blazebit.persistence.parser.expression.cache.InPredicateExpression", this.delegate, parameterOrLiteralExpression, false, false, false, macroConfiguration, IN_ITEM_EXPRESSION_SUPPLIER);
    }

    @Override
    public Expression createInItemOrPathExpression(String parameterOrLiteralExpression, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        return this.getOrDefault("com.blazebit.persistence.parser.expression.cache.InPredicateSingleExpression", this.delegate, parameterOrLiteralExpression, false, false, false, macroConfiguration, IN_ITEM_OR_PATH_EXPRESSION_SUPPLIER);
    }

    @Override
    public Predicate createBooleanExpression(String expression, boolean allowQuantifiedPredicates, MacroConfiguration macroConfiguration, Set<String> usedMacros) {
        return (Predicate)this.getOrDefault("com.blazebit.persistence.parser.expression.cache.PredicateExpression", this.delegate, expression, false, allowQuantifiedPredicates, false, macroConfiguration, BOOLEAN_EXPRESSION_SUPPLIER);
    }

    private <E extends Expression> E getOrDefault(String cacheName, ExpressionFactory expressionFactory, String expression, boolean allowOuter, boolean allowQuantifiedPredicates, boolean allowObjectExpression, MacroConfiguration macroConfiguration, ExpressionSupplier defaultExpressionSupplier) {
        Expression expr;
        ExpressionCacheEntry exprEntry = this.expressionCache.get(cacheName, new ExpressionCache.Key(expression, allowOuter, allowQuantifiedPredicates, allowObjectExpression));
        MacroConfiguration macroKey = null;
        if (exprEntry == null) {
            HashSet<String> usedMacros = new HashSet<String>();
            Expression expr2 = defaultExpressionSupplier.get(expressionFactory, expression, allowOuter, allowQuantifiedPredicates, allowObjectExpression, macroConfiguration, usedMacros);
            exprEntry = new ExpressionCacheEntry(expr2, usedMacros);
            if (!usedMacros.isEmpty()) {
                macroKey = exprEntry.createKey(macroConfiguration);
                if (macroKey == null) {
                    return (E)expr2;
                }
                exprEntry.addMacroConfigurationExpression(macroKey, expr2);
            }
            this.expressionCache.putIfAbsent(cacheName, new ExpressionCache.Key(expression, allowOuter, allowQuantifiedPredicates, allowObjectExpression), exprEntry);
            return (E)expr2.copy(ExpressionCopyContext.EMPTY);
        }
        if (exprEntry.usedMacros == null) {
            expr = exprEntry.expression;
        } else {
            Expression oldExpr;
            if (macroKey == null && (macroKey = exprEntry.createKey(macroConfiguration)) == null) {
                return (E)defaultExpressionSupplier.get(expressionFactory, expression, allowOuter, allowQuantifiedPredicates, allowObjectExpression, macroConfiguration, null);
            }
            expr = exprEntry.macroConfigurationCache.get(macroKey);
            if (expr == null && (oldExpr = exprEntry.macroConfigurationCache.putIfAbsent(macroKey, expr = defaultExpressionSupplier.get(expressionFactory, expression, allowOuter, allowQuantifiedPredicates, allowObjectExpression, macroConfiguration, null))) != null) {
                expr = oldExpr;
            }
        }
        return (E)expr.copy(ExpressionCopyContext.EMPTY);
    }

    private static interface ExpressionSupplier {
        public Expression get(ExpressionFactory var1, String var2, boolean var3, boolean var4, boolean var5, MacroConfiguration var6, Set<String> var7);
    }

    private static final class ExpressionCacheEntry {
        final Expression expression;
        final Set<String> usedMacros;
        final ConcurrentHashMap<MacroConfiguration, Expression> macroConfigurationCache;

        public ExpressionCacheEntry(Expression expression, Set<String> usedMacros) {
            if (usedMacros.isEmpty()) {
                this.expression = expression;
                this.usedMacros = null;
                this.macroConfigurationCache = null;
            } else {
                this.expression = null;
                this.usedMacros = usedMacros;
                this.macroConfigurationCache = new ConcurrentHashMap();
            }
        }

        public MacroConfiguration createKey(MacroConfiguration macroConfiguration) {
            HashMap<String, MacroFunction> macros = new HashMap<String, MacroFunction>(this.usedMacros.size());
            for (String usedMacro : this.usedMacros) {
                MacroFunction macroFunction = macroConfiguration.get(usedMacro);
                if (!macroFunction.supportsCaching()) {
                    return null;
                }
                macros.put(usedMacro, macroFunction);
            }
            return MacroConfiguration.of(macros);
        }

        public void addMacroConfigurationExpression(MacroConfiguration macroConfiguration, Expression expression) {
            this.macroConfigurationCache.put(macroConfiguration, expression);
        }
    }
}

