/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.antlr.atn;

import com.blazebit.persistence.parser.antlr.atn.ATNState;
import com.blazebit.persistence.parser.antlr.atn.AtomTransition;
import com.blazebit.persistence.parser.antlr.atn.RangeTransition;
import com.blazebit.persistence.parser.antlr.atn.SetTransition;
import com.blazebit.persistence.parser.antlr.atn.Transition;
import com.blazebit.persistence.parser.antlr.misc.IntervalSet;

public abstract class CodePointTransitions {
    public static Transition createWithCodePoint(ATNState target, int codePoint) {
        if (Character.isSupplementaryCodePoint(codePoint)) {
            return new SetTransition(target, IntervalSet.of(codePoint));
        }
        return new AtomTransition(target, codePoint);
    }

    public static Transition createWithCodePointRange(ATNState target, int codePointFrom, int codePointTo) {
        if (Character.isSupplementaryCodePoint(codePointFrom) || Character.isSupplementaryCodePoint(codePointTo)) {
            return new SetTransition(target, IntervalSet.of(codePointFrom, codePointTo));
        }
        return new RangeTransition(target, codePointFrom, codePointTo);
    }
}

