/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.api;

import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.response.HealthResponse;
import com.bettercloud.vault.rest.Rest;
import com.bettercloud.vault.rest.RestException;
import com.bettercloud.vault.rest.RestResponse;
import java.util.HashSet;

public class Debug {
    private final VaultConfig config;
    private String nameSpace;

    public Debug(VaultConfig config) {
        this.config = config;
        if (this.config.getNameSpace() != null && !this.config.getNameSpace().isEmpty()) {
            this.nameSpace = this.config.getNameSpace();
        }
    }

    public Debug withNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    public HealthResponse health() throws VaultException {
        return this.health(null, null, null, null);
    }

    public HealthResponse health(Boolean standbyOk, Integer activeCode, Integer standbyCode, Integer sealedCode) throws VaultException {
        String path = "sys/health";
        int retryCount = 0;
        while (true) {
            try {
                Rest rest = new Rest().url(this.config.getAddress() + "/v1/" + "sys/health").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext());
                if (this.config.getToken() != null) {
                    rest.header("X-Vault-Token", this.config.getToken());
                }
                rest.optionalHeader("X-Vault-Namespace", this.nameSpace);
                if (standbyOk != null) {
                    rest.parameter("standbyok", standbyOk.toString());
                }
                if (activeCode != null) {
                    rest.parameter("activecode", activeCode.toString());
                }
                if (standbyCode != null) {
                    rest.parameter("standbycode", standbyCode.toString());
                }
                if (sealedCode != null) {
                    rest.parameter("sealedcode", sealedCode.toString());
                }
                RestResponse restResponse = rest.get();
                HashSet<Integer> validCodes = new HashSet<Integer>();
                validCodes.add(200);
                validCodes.add(429);
                validCodes.add(500);
                if (activeCode != null) {
                    validCodes.add(activeCode);
                }
                if (standbyCode != null) {
                    validCodes.add(standbyCode);
                }
                if (sealedCode != null) {
                    validCodes.add(sealedCode);
                }
                if (!validCodes.contains(restResponse.getStatus())) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                return new HealthResponse(restResponse, retryCount);
            }
            catch (VaultException | RestException | RuntimeException e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }
}

