/*
 * Decompiled with CFR 0.152.
 */
package com.bendb.dropwizard.jooq.jersey;

import com.google.common.annotations.VisibleForTesting;
import io.dropwizard.jersey.errors.LoggingExceptionMapper;
import java.sql.SQLException;
import javax.ws.rs.ext.Provider;
import org.jooq.exception.DataAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class LoggingDataAccessExceptionMapper
extends LoggingExceptionMapper<DataAccessException> {
    private static Logger logger = LoggerFactory.getLogger(LoggingDataAccessExceptionMapper.class);

    protected void logException(long id, DataAccessException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof SQLException) {
            for (Throwable throwable : (SQLException)cause) {
                logger.error(this.formatLogMessage(id, throwable), throwable);
            }
        } else {
            logger.error(this.formatLogMessage(id, (Throwable)exception), (Throwable)exception);
        }
    }

    @VisibleForTesting
    static void setLogger(Logger logger) {
        LoggingDataAccessExceptionMapper.logger = logger;
    }
}

