/*
 * Decompiled with CFR 0.152.
 */
package com.bendb.dropwizard.jooq;

import com.google.common.base.Optional;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.db.ManagedDataSource;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import javax.sql.DataSource;
import javax.validation.constraints.NotNull;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.SQLDialect;
import org.jooq.conf.ParamType;
import org.jooq.conf.RenderKeywordStyle;
import org.jooq.conf.RenderNameStyle;
import org.jooq.conf.Settings;
import org.jooq.conf.StatementType;
import org.jooq.impl.DataSourceConnectionProvider;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.tools.jdbc.JDBCUtils;

public class JooqFactory {
    private static final String DEFAULT_NAME = "jooq";
    @NotNull
    private Optional<SQLDialect> dialect = Optional.absent();
    private boolean renderSchema = true;
    @NotNull
    private RenderNameStyle renderNameStyle = RenderNameStyle.QUOTED;
    @NotNull
    private RenderKeywordStyle renderKeywordStyle = RenderKeywordStyle.UPPER;
    private boolean renderFormatted = false;
    @NotNull
    private ParamType paramType = ParamType.INDEXED;
    @NotNull
    private StatementType statementType = StatementType.PREPARED_STATEMENT;
    private boolean executeLogging = false;
    private boolean executeWithOptimisticLocking = false;
    private boolean attachRecords = true;
    private boolean updatablePrimaryKeys = false;
    private boolean fetchWarnings = true;

    public Optional<SQLDialect> getDialect() {
        return this.dialect;
    }

    public void setDialect(Optional<SQLDialect> dialect) {
        this.dialect = dialect;
    }

    @Deprecated
    public boolean isLogExecutedSql() {
        return this.executeLogging;
    }

    @Deprecated
    public void setLogExecutedSql(boolean logExecutedSql) {
        this.executeLogging = logExecutedSql;
    }

    public boolean isRenderSchema() {
        return this.renderSchema;
    }

    public void setRenderSchema(boolean renderSchema) {
        this.renderSchema = renderSchema;
    }

    public RenderNameStyle getRenderNameStyle() {
        return this.renderNameStyle;
    }

    public void setRenderNameStyle(RenderNameStyle renderNameStyle) {
        this.renderNameStyle = renderNameStyle;
    }

    public RenderKeywordStyle getRenderKeywordStyle() {
        return this.renderKeywordStyle;
    }

    public void setRenderKeywordStyle(RenderKeywordStyle renderKeywordStyle) {
        this.renderKeywordStyle = renderKeywordStyle;
    }

    public boolean isRenderFormatted() {
        return this.renderFormatted;
    }

    public void setRenderFormatted(boolean renderFormatted) {
        this.renderFormatted = renderFormatted;
    }

    public ParamType getParamType() {
        return this.paramType;
    }

    public void setParamType(ParamType paramType) {
        this.paramType = paramType;
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public void setStatementType(StatementType statementType) {
        this.statementType = statementType;
    }

    public boolean isExecuteLogging() {
        return this.executeLogging;
    }

    public void setExecuteLogging(boolean executeLogging) {
        this.executeLogging = executeLogging;
    }

    public boolean isExecuteWithOptimisticLocking() {
        return this.executeWithOptimisticLocking;
    }

    public void setExecuteWithOptimisticLocking(boolean executeWithOptimisticLocking) {
        this.executeWithOptimisticLocking = executeWithOptimisticLocking;
    }

    public boolean isAttachRecords() {
        return this.attachRecords;
    }

    public void setAttachRecords(boolean attachRecords) {
        this.attachRecords = attachRecords;
    }

    public boolean isUpdatablePrimaryKeys() {
        return this.updatablePrimaryKeys;
    }

    public void setUpdatablePrimaryKeys(boolean updatablePrimaryKeys) {
        this.updatablePrimaryKeys = updatablePrimaryKeys;
    }

    public boolean isFetchWarnings() {
        return this.fetchWarnings;
    }

    public void setFetchWarnings(boolean fetchWarnings) {
        this.fetchWarnings = fetchWarnings;
    }

    public Configuration build(Environment environment, DataSourceFactory factory) throws ClassNotFoundException {
        return this.build(environment, (PooledDataSourceFactory)factory, DEFAULT_NAME);
    }

    public Configuration build(Environment environment, PooledDataSourceFactory factory, String name) throws ClassNotFoundException {
        Settings settings = this.buildSettings();
        ManagedDataSource dataSource = factory.build(environment.metrics(), name);
        SQLDialect dialect = this.determineDialect(factory, dataSource);
        DataSourceConnectionProvider connectionProvider = new DataSourceConnectionProvider((DataSource)dataSource);
        Configuration config = new DefaultConfiguration().set(settings).set(dialect).set((ConnectionProvider)connectionProvider);
        environment.lifecycle().manage((Managed)dataSource);
        return config;
    }

    private SQLDialect determineDialect(PooledDataSourceFactory dataSourceFactory, ManagedDataSource dataSource) {
        if (this.getDialect().isPresent()) {
            return (SQLDialect)this.dialect.get();
        }
        return JDBCUtils.dialect((String)dataSourceFactory.getUrl());
    }

    private Settings buildSettings() {
        Settings settings = new Settings();
        settings.setRenderSchema(Boolean.valueOf(this.renderSchema));
        settings.setRenderNameStyle(this.renderNameStyle);
        settings.setRenderKeywordStyle(this.renderKeywordStyle);
        settings.setRenderFormatted(Boolean.valueOf(this.renderFormatted));
        settings.setParamType(this.paramType);
        settings.setStatementType(this.statementType);
        settings.setExecuteLogging(Boolean.valueOf(this.executeLogging));
        settings.setExecuteWithOptimisticLocking(Boolean.valueOf(this.executeWithOptimisticLocking));
        settings.setAttachRecords(Boolean.valueOf(this.attachRecords));
        settings.setUpdatablePrimaryKeys(Boolean.valueOf(this.updatablePrimaryKeys));
        settings.setFetchWarnings(Boolean.valueOf(this.fetchWarnings));
        return settings;
    }
}

