/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.nlp.coreference.measures;

import com.bbn.bue.common.collections.CollectionUtils;
import com.bbn.nlp.coreference.measures.BLANCResult;
import com.bbn.nlp.coreference.measures.BLANCScorer;
import com.bbn.nlp.coreference.measures.CorefScorerUtils;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Beta
final class StandardBLANCScorer
implements BLANCScorer {
    private final boolean useSelfEdges;

    StandardBLANCScorer(boolean useSelfEdges) {
        this.useSelfEdges = useSelfEdges;
    }

    @Override
    public BLANCResult score(Iterable<? extends Iterable<?>> predicted, Iterable<? extends Iterable<?>> gold) {
        List<Set<Object>> predictedAsSets = CorefScorerUtils.toSets(predicted);
        List<Set<Object>> goldAsSets = CorefScorerUtils.toSets(gold);
        return this.scoreSets(predictedAsSets, goldAsSets);
    }

    private BLANCResult scoreSets(Iterable<Set<Object>> predicted, Iterable<Set<Object>> gold) {
        Map predictedItemToGroup = CollectionUtils.makeElementsToContainersMap(predicted);
        Map goldItemToGroup = CollectionUtils.makeElementsToContainersMap(gold);
        CorefScorerUtils.checkPartitionsOverSameElements(predictedItemToGroup.keySet(), goldItemToGroup.keySet());
        double corefLinksInBoth = 0.0;
        double corefLinksInKey = 0.0;
        double corefLinksInResponse = 0.0;
        double nonCorefInBoth = 0.0;
        double nonCorefLinksInKey = 0.0;
        double nonCorefLinksInResponse = 0.0;
        Set allItems = predictedItemToGroup.keySet();
        for (Object item : allItems) {
            HashSet predictedNeighbors = Sets.newHashSet((Iterable)((Iterable)predictedItemToGroup.get(item)));
            if (!this.useSelfEdges) {
                predictedNeighbors.remove(item);
            }
            HashSet goldNeighbors = Sets.newHashSet((Iterable)((Iterable)goldItemToGroup.get(item)));
            if (!this.useSelfEdges) {
                goldNeighbors.remove(item);
            }
            corefLinksInBoth += (double)Sets.intersection((Set)predictedNeighbors, (Set)goldNeighbors).size();
            corefLinksInResponse += (double)predictedNeighbors.size();
            corefLinksInKey += (double)goldNeighbors.size();
            nonCorefLinksInKey += (double)(allItems.size() - goldNeighbors.size() + (this.useSelfEdges ? 0 : -1));
            nonCorefLinksInResponse += (double)(allItems.size() - predictedNeighbors.size() + (this.useSelfEdges ? 0 : -1));
            ImmutableSet neighborsInEither = Sets.union((Set)predictedNeighbors, (Set)goldNeighbors).immutableCopy();
            nonCorefInBoth += (double)(Sets.difference(allItems, (Set)neighborsInEither).size() + (this.useSelfEdges ? 0 : -1));
        }
        return BLANCResult.fromSetCounts(true, corefLinksInBoth, corefLinksInKey, corefLinksInResponse, nonCorefInBoth, nonCorefLinksInKey, nonCorefLinksInResponse);
    }
}

