/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.nlp.coreference.measures;

import com.bbn.bue.common.collections.CollectionUtils;
import com.bbn.nlp.coreference.measures.BLANCResult;
import com.bbn.nlp.coreference.measures.BLANCScorer;
import com.bbn.nlp.coreference.measures.CorefScorerUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Beta
public final class MultiBLANCScorer
implements BLANCScorer {
    private final boolean useSelfEdges;

    MultiBLANCScorer(boolean useSelfEdges) {
        this.useSelfEdges = useSelfEdges;
    }

    @Override
    public BLANCResult score(Iterable<? extends Iterable<?>> predicted, Iterable<? extends Iterable<?>> gold) {
        List<Set<Object>> predictedAsSets = CorefScorerUtils.toSets(predicted);
        List<Set<Object>> goldAsSets = CorefScorerUtils.toSets(gold);
        return this.scoreSets(predictedAsSets, goldAsSets);
    }

    private BLANCResult scoreSets(Iterable<Set<Object>> predicted, Iterable<Set<Object>> gold) {
        ImmutableListMultimap predictedItemToGroup = CollectionUtils.makeSetElementsToContainersMultimap(predicted);
        ImmutableListMultimap goldItemToGroup = CollectionUtils.makeSetElementsToContainersMultimap(gold);
        Set keyItems = goldItemToGroup.keySet();
        Set responseItems = predictedItemToGroup.keySet();
        ImmutableSet itemsInBoth = Sets.intersection((Set)keyItems, (Set)responseItems).immutableCopy();
        int corefLinksInBoth = 0;
        int corefLinksInKey = 0;
        int corefLinksInResponse = 0;
        int nonCorefInBoth = 0;
        int nonCorefLinksInKey = 0;
        int nonCorefLinksInResponse = 0;
        ImmutableSet allItems = Sets.union((Set)responseItems, (Set)keyItems).immutableCopy();
        for (Object item : allItems) {
            boolean inKey = keyItems.contains(item);
            boolean inResponse = responseItems.contains(item);
            Collection predictedClusters = predictedItemToGroup.get(item);
            Collection goldClusters = goldItemToGroup.get(item);
            Predicate SELF_ADJUSTMENT_FILTER = this.useSelfEdges ? Predicates.alwaysTrue() : Predicates.not((Predicate)Predicates.equalTo(item));
            int selfAdjustment = this.useSelfEdges ? 0 : -1;
            ImmutableSet predictedNeighbors = FluentIterable.from((Iterable)Iterables.concat((Iterable)predictedClusters)).filter(SELF_ADJUSTMENT_FILTER).toSet();
            ImmutableSet goldNeighbors = FluentIterable.from((Iterable)Iterables.concat((Iterable)goldClusters)).filter(SELF_ADJUSTMENT_FILTER).toSet();
            corefLinksInBoth += Sets.intersection((Set)predictedNeighbors, (Set)goldNeighbors).size();
            corefLinksInResponse += predictedNeighbors.size();
            corefLinksInKey += goldNeighbors.size();
            if (inKey) {
                nonCorefLinksInKey += keyItems.size() - goldNeighbors.size() + selfAdjustment;
            }
            if (inResponse) {
                nonCorefLinksInResponse += responseItems.size() - predictedNeighbors.size() + selfAdjustment;
            }
            if (!inKey || !inResponse) continue;
            ImmutableSet neighborsInEither = Sets.union((Set)predictedNeighbors, (Set)goldNeighbors).immutableCopy();
            nonCorefInBoth += Sets.difference((Set)itemsInBoth, (Set)neighborsInEither).size() + selfAdjustment;
        }
        return BLANCResult.fromSetCounts(keyItems.equals(responseItems), corefLinksInBoth, corefLinksInKey, corefLinksInResponse, nonCorefInBoth, nonCorefLinksInKey, nonCorefLinksInResponse);
    }
}

