/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.nlp.coreference.measures;

import com.bbn.bue.common.collections.CollectionUtils;
import com.bbn.bue.common.evaluation.FMeasureInfo;
import com.bbn.bue.common.evaluation.PrecisionRecallPair;
import com.bbn.nlp.coreference.measures.CorefScorerUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Beta
public final class MUCScorer {
    private MUCScorer() {
    }

    public static MUCScorer create() {
        return new MUCScorer();
    }

    public Optional<FMeasureInfo> score(Iterable<? extends Iterable<?>> predicted, Iterable<? extends Iterable<?>> gold) {
        List<Set<Object>> predictedAsSets = CorefScorerUtils.toSets(predicted);
        List<Set<Object>> goldAsSets = CorefScorerUtils.toSets(gold);
        Map predictedItemToGroup = CollectionUtils.makeElementsToContainersMap(predictedAsSets);
        Map goldItemToGroup = CollectionUtils.makeElementsToContainersMap(goldAsSets);
        CorefScorerUtils.checkPartitionsOverSameElements(predictedItemToGroup.keySet(), goldItemToGroup.keySet());
        Optional<Float> recall = this.mucScoreComponent(goldAsSets, predictedAsSets, predictedItemToGroup);
        Optional<Float> precision = this.mucScoreComponent(predictedAsSets, goldAsSets, goldItemToGroup);
        if (recall.isPresent() && precision.isPresent()) {
            return Optional.of((Object)new PrecisionRecallPair(((Float)precision.get()).floatValue(), ((Float)recall.get()).floatValue()));
        }
        return Optional.absent();
    }

    private Optional<Float> mucScoreComponent(List<Set<Object>> leftClustering, List<Set<Object>> rightClustering, Map<Object, Set<Object>> rightItemToGroup) {
        int numerator = 0;
        int denominator = 0;
        for (Set<Object> leftCluster : leftClustering) {
            HashSet rightClustersThisOneOverlaps = Sets.newHashSet();
            for (Object leftClusterItem : leftCluster) {
                rightClustersThisOneOverlaps.add(rightItemToGroup.get(leftClusterItem));
            }
            int overlapSize = rightClustersThisOneOverlaps.size();
            int leftClusterSize = leftCluster.size();
            numerator += leftClusterSize - overlapSize;
            denominator += leftClusterSize - 1;
        }
        if (denominator > 0) {
            return Optional.of((Object)Float.valueOf((float)numerator / (float)denominator));
        }
        return Optional.absent();
    }
}

