/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.nlp.coreference.measures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;

final class CorefScorerUtils {
    private CorefScorerUtils() {
    }

    static void checkPartitionsOverSameElements(Set<Object> predictedItems, Set<Object> goldItems) {
        if (!predictedItems.equals(goldItems)) {
            Sets.SetView predictedButNotGold = Sets.difference(predictedItems, goldItems);
            Sets.SetView goldButNotPredicted = Sets.difference(goldItems, predictedItems);
            throw new RuntimeException(String.format("Elements in partitions must match. In predicted but not gold: %s. In gold but not predicted: %s", predictedButNotGold, goldButNotPredicted));
        }
    }

    static List<Set<Object>> toSets(Iterable<? extends Iterable<?>> iterables) {
        ImmutableList.Builder ret = ImmutableList.builder();
        for (Iterable<?> iterable : iterables) {
            ret.add((Object)ImmutableSet.copyOf(iterable));
        }
        return ret.build();
    }
}

