/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.nlp.coreference.measures;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;

@Beta
public final class BLANCResult {
    private final double P_C;
    private final double P_N;
    private final double R_C;
    private final double R_N;
    private final double F_C;
    private final double F_N;
    private final double blancScore;
    private final double blancP;
    private final double blancR;

    private BLANCResult(double p_C, double p_N, double r_C, double r_N, double F_C, double F_N, double blancScore) {
        this.P_C = p_C;
        this.P_N = p_N;
        this.R_C = r_C;
        this.R_N = r_N;
        this.F_N = F_N;
        this.F_C = F_C;
        this.blancP = 0.5 * this.P_C + 0.5 * this.P_N;
        this.blancR = 0.5 * this.R_C + 0.5 * this.R_N;
        this.blancScore = blancScore;
    }

    static BLANCResult fromSetCounts(boolean itemSetsMatch, double corefLinksInBoth, double corefLinksInKey, double corefLinksInResponse, double nonCorefLinksInBoth, double nonCorefLinksInKey, double nonCorefLinksInResponse) {
        boolean noNonCorefLinksOnEitherSide;
        double R_C = corefLinksInBoth / corefLinksInKey;
        double P_C = corefLinksInBoth / corefLinksInResponse;
        double R_N = nonCorefLinksInBoth / nonCorefLinksInKey;
        double P_N = nonCorefLinksInBoth / nonCorefLinksInResponse;
        double F_C = 2.0 * corefLinksInBoth / (corefLinksInKey + corefLinksInResponse);
        double F_N = 2.0 * nonCorefLinksInBoth / (nonCorefLinksInKey + nonCorefLinksInResponse);
        boolean noCorefLinksOnEitherSide = corefLinksInKey == 0.0 && corefLinksInResponse == 0.0;
        boolean bl = noNonCorefLinksOnEitherSide = nonCorefLinksInKey == 0.0 && nonCorefLinksInResponse == 0.0;
        double blancScore = noCorefLinksOnEitherSide && noNonCorefLinksOnEitherSide ? (itemSetsMatch ? 1.0 : 0.0) : (noCorefLinksOnEitherSide ? F_N : (noNonCorefLinksOnEitherSide ? F_C : 0.5 * (F_N + F_C)));
        return new BLANCResult(P_C, P_N, R_C, R_N, F_C, F_N, blancScore);
    }

    public Optional<Double> corefLinkPrecision() {
        return BLANCResult.ifDefined(this.P_C);
    }

    public Optional<Double> nonCorefLinkPrecision() {
        return BLANCResult.ifDefined(this.P_N);
    }

    public Optional<Double> corefLinkRecall() {
        return BLANCResult.ifDefined(this.R_C);
    }

    public Optional<Double> nonCorefLinkRecall() {
        return BLANCResult.ifDefined(this.R_N);
    }

    public Optional<Double> corefLinkF1() {
        return BLANCResult.ifDefined(this.F_C);
    }

    public Optional<Double> nonCorefLinkF1() {
        return BLANCResult.ifDefined(this.F_N);
    }

    public Optional<Double> blancPrecision() {
        return BLANCResult.ifDefined(this.blancP);
    }

    public Optional<Double> blancRecall() {
        return BLANCResult.ifDefined(this.blancR);
    }

    public double blancScore() {
        return this.blancScore;
    }

    private static Optional<Double> ifDefined(double d) {
        if (Double.isNaN(d)) {
            return Optional.absent();
        }
        return Optional.of((Object)d);
    }
}

