/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.nlp.coreference.measures;

import com.bbn.bue.common.collections.CollectionUtils;
import com.bbn.bue.common.evaluation.FMeasureInfo;
import com.bbn.bue.common.evaluation.PrecisionRecallPair;
import com.bbn.nlp.coreference.measures.CorefScorerUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class B3Scorer {
    private final B3Method method;

    private B3Scorer(B3Method method) {
        this.method = (B3Method)((Object)Preconditions.checkNotNull((Object)((Object)method)));
    }

    public static B3Scorer createByElementScorer() {
        return new B3Scorer(B3Method.ByElement);
    }

    public FMeasureInfo score(Iterable<? extends Iterable<?>> predicted, Iterable<? extends Iterable<?>> gold) {
        List<Set<Object>> predictedAsSets = CorefScorerUtils.toSets(predicted);
        List<Set<Object>> goldAsSets = CorefScorerUtils.toSets(gold);
        if (this.method == B3Method.ByElement) {
            return this.scoreSets(predictedAsSets, goldAsSets);
        }
        throw new RuntimeException("B3Method.ByCluster not yet implemented");
    }

    private FMeasureInfo scoreSets(Iterable<Set<Object>> predicted, Iterable<Set<Object>> gold) {
        Map predictedItemToGroup = CollectionUtils.makeElementsToContainersMap(predicted);
        Map goldItemToGroup = CollectionUtils.makeElementsToContainersMap(gold);
        CorefScorerUtils.checkPartitionsOverSameElements(predictedItemToGroup.keySet(), goldItemToGroup.keySet());
        if (predictedItemToGroup.isEmpty()) {
            return new PrecisionRecallPair(0.0f, 0.0f);
        }
        double precisionTotal = 0.0;
        double recallTotal = 0.0;
        for (Object item : goldItemToGroup.keySet()) {
            Set goldGroup = (Set)goldItemToGroup.get(item);
            Set predictedGroup = (Set)predictedItemToGroup.get(item);
            Sets.SetView inBoth = Sets.intersection((Set)goldGroup, (Set)predictedGroup);
            precisionTotal += (double)inBoth.size() / (double)predictedGroup.size();
            recallTotal += (double)inBoth.size() / (double)goldGroup.size();
        }
        return new PrecisionRecallPair((float)(precisionTotal / (double)goldItemToGroup.keySet().size()), (float)(recallTotal / (double)goldItemToGroup.keySet().size()));
    }

    private static enum B3Method {
        ByCluster,
        ByElement;

    }
}

