/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.modifier.spec;

import com.bazaarvoice.jolt.common.ComputedKeysComparator;
import com.bazaarvoice.jolt.common.ExecutionStrategy;
import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.common.pathelement.ArrayPathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.MatchablePathElement;
import com.bazaarvoice.jolt.common.pathelement.StarAllPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarDoublePathElement;
import com.bazaarvoice.jolt.common.pathelement.StarRegexPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarSinglePathElement;
import com.bazaarvoice.jolt.common.spec.BaseSpec;
import com.bazaarvoice.jolt.common.spec.OrderedCompositeSpec;
import com.bazaarvoice.jolt.common.tree.ArrayMatchedElement;
import com.bazaarvoice.jolt.common.tree.MatchedElement;
import com.bazaarvoice.jolt.common.tree.WalkedPath;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.modifier.DataType;
import com.bazaarvoice.jolt.modifier.OpMode;
import com.bazaarvoice.jolt.modifier.TemplatrSpecBuilder;
import com.bazaarvoice.jolt.modifier.spec.ModifierSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModifierCompositeSpec
extends ModifierSpec
implements OrderedCompositeSpec {
    private static final HashMap<Class, Integer> orderMap = new HashMap();
    private static final ComputedKeysComparator computedKeysComparator;
    private final Map<String, ModifierSpec> literalChildren;
    private final List<ModifierSpec> computedChildren;
    private final ExecutionStrategy executionStrategy;
    private final DataType specDataType;

    public ModifierCompositeSpec(String key, Map<String, Object> spec, OpMode opMode, TemplatrSpecBuilder specBuilder) {
        super(key, opMode);
        LinkedHashMap<String, ModifierSpec> literals = new LinkedHashMap<String, ModifierSpec>();
        ArrayList<ModifierSpec> computed = new ArrayList<ModifierSpec>();
        List children = specBuilder.createSpec(spec);
        int maxExplicitIndexFromSpec = -1;
        int confirmedMapAtIndex = -1;
        int confirmedArrayAtIndex = -1;
        for (int i = 0; i < children.size(); ++i) {
            ModifierSpec childSpec = (ModifierSpec)children.get(i);
            MatchablePathElement childPathElement = childSpec.pathElement;
            if (childPathElement instanceof LiteralPathElement) {
                confirmedMapAtIndex = i;
                literals.put(childPathElement.getRawKey(), childSpec);
            } else if (childPathElement instanceof ArrayPathElement) {
                confirmedArrayAtIndex = i;
                ArrayPathElement childArrayPathElement = (ArrayPathElement)childPathElement;
                if (!childArrayPathElement.isExplicitArrayIndex()) {
                    throw new SpecException(opMode.name() + " RHS only supports explicit Array path element");
                }
                int explicitIndex = childArrayPathElement.getExplicitArrayIndex();
                if (!childSpec.checkValue) {
                    maxExplicitIndexFromSpec = Math.max(maxExplicitIndexFromSpec, explicitIndex);
                }
                literals.put(String.valueOf(explicitIndex), childSpec);
            } else {
                if (!(childPathElement instanceof StarAllPathElement)) {
                    confirmedMapAtIndex = i;
                }
                computed.add(childSpec);
            }
            if (confirmedMapAtIndex <= -1 || confirmedArrayAtIndex <= -1) continue;
            throw new SpecException(opMode.name() + " RHS cannot mix int array index and string map key, defined spec for " + key + " contains: " + ((ModifierSpec)children.get((int)confirmedMapAtIndex)).pathElement.getCanonicalForm() + " conflicting " + ((ModifierSpec)children.get((int)confirmedArrayAtIndex)).pathElement.getCanonicalForm());
        }
        this.specDataType = DataType.determineDataType(confirmedArrayAtIndex, confirmedMapAtIndex, maxExplicitIndexFromSpec);
        Collections.sort(computed, computedKeysComparator);
        computed.trimToSize();
        this.literalChildren = Collections.unmodifiableMap(literals);
        this.computedChildren = Collections.unmodifiableList(computed);
        this.executionStrategy = this.determineExecutionStrategy();
    }

    @Override
    public void applyElement(String inputKey, Optional<Object> inputOptional, MatchedElement thisLevel, WalkedPath walkedPath, Map<String, Object> context) {
        Object input = inputOptional.get();
        if (!this.specDataType.isCompatible(input)) {
            return;
        }
        if (input == null && (input = this.specDataType.create(inputKey, walkedPath, this.opMode)) != null) {
            inputOptional = Optional.of(input);
        }
        if (input instanceof List) {
            if (this.specDataType instanceof DataType.LIST) {
                int origSize = this.specDataType.expand(input);
                thisLevel = new ArrayMatchedElement(thisLevel.getRawKey(), origSize);
            } else {
                thisLevel = new ArrayMatchedElement(thisLevel.getRawKey(), ((List)input).size());
            }
        }
        walkedPath.add(input, thisLevel);
        this.executionStrategy.process(this, inputOptional, walkedPath, null, context);
        walkedPath.removeLast();
    }

    @Override
    public Map<String, ? extends BaseSpec> getLiteralChildren() {
        return this.literalChildren;
    }

    @Override
    public List<? extends BaseSpec> getComputedChildren() {
        return this.computedChildren;
    }

    @Override
    public ExecutionStrategy determineExecutionStrategy() {
        if (this.computedChildren.isEmpty()) {
            return ExecutionStrategy.ALL_LITERALS;
        }
        if (this.literalChildren.isEmpty()) {
            return ExecutionStrategy.COMPUTED;
        }
        if (this.opMode.equals((Object)OpMode.DEFINER) && this.specDataType instanceof DataType.LIST) {
            return ExecutionStrategy.CONFLICT;
        }
        return ExecutionStrategy.ALL_LITERALS_WITH_COMPUTED;
    }

    static {
        orderMap.put(ArrayPathElement.class, 1);
        orderMap.put(StarRegexPathElement.class, 2);
        orderMap.put(StarDoublePathElement.class, 3);
        orderMap.put(StarSinglePathElement.class, 4);
        orderMap.put(StarAllPathElement.class, 5);
        computedKeysComparator = ComputedKeysComparator.fromOrder(orderMap);
    }
}

