/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.defaultr;

import com.bazaarvoice.jolt.exception.SpecException;
import java.util.Comparator;

public enum OPS {
    STAR,
    OR,
    LITERAL;


    public static OPS parse(String key) {
        if (key.contains("*")) {
            if (!"*".equals(key)) {
                throw new SpecException("Defaultr key " + key + " is invalid.  * keys can only contain *, and no other characters.");
            }
            return STAR;
        }
        if (key.contains("|")) {
            return OR;
        }
        return LITERAL;
    }

    public static class OpsPrecedenceComparator
    implements Comparator<OPS> {
        @Override
        public int compare(OPS ops, OPS ops1) {
            if (ops == ops1) {
                return 0;
            }
            if (STAR == ops) {
                return 1;
            }
            if (LITERAL == ops) {
                return -1;
            }
            if (STAR == ops1) {
                return -1;
            }
            if (LITERAL == ops1) {
                return 1;
            }
            throw new IllegalStateException("Someone has added an op type without changing this method.");
        }
    }
}

