/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.defaultr;

import com.bazaarvoice.jolt.common.DeepCopy;
import com.bazaarvoice.jolt.defaultr.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ArrayKey
extends Key {
    private Collection<Integer> keyInts;
    private int keyInt = -1;

    public ArrayKey(String jsonKey, Object spec) {
        super(jsonKey, spec);
        switch (this.getOp()) {
            case OR: {
                this.keyInts = new ArrayList<Integer>();
                for (String orLiteral : this.keyStrings) {
                    int orInt = Integer.parseInt(orLiteral);
                    this.keyInts.add(orInt);
                }
                break;
            }
            case LITERAL: {
                this.keyInt = Integer.parseInt(this.rawKey);
                this.keyInts = Arrays.asList(this.keyInt);
                break;
            }
            case STAR: {
                this.keyInts = Collections.emptyList();
                break;
            }
            default: {
                throw new IllegalStateException("Someone has added an op type without changing this method.");
            }
        }
    }

    @Override
    protected int getLiteralIntKey() {
        return this.keyInt;
    }

    @Override
    protected void applyChild(Object container) {
        if (container instanceof List) {
            List defaultList = (List)container;
            for (Integer literalKey : this.determineMatchingContainerKeys(defaultList)) {
                this.applyLiteralKeyToContainer(literalKey, defaultList);
            }
        }
    }

    private void applyLiteralKeyToContainer(Integer literalIndex, List<Object> container) {
        Object defaulteeValue = container.get(literalIndex);
        if (this.children == null) {
            if (defaulteeValue == null) {
                container.set(literalIndex, DeepCopy.simpleDeepCopy(this.literalValue));
            }
        } else {
            if (defaulteeValue == null) {
                defaulteeValue = this.createOutputContainerObject();
                container.set(literalIndex, defaulteeValue);
            }
            this.applyChildren(defaulteeValue);
        }
    }

    private Collection<Integer> determineMatchingContainerKeys(List<Object> container) {
        switch (this.getOp()) {
            case LITERAL: {
                return this.keyInts;
            }
            case STAR: {
                List<Object> defaultList = container;
                ArrayList<Integer> allIndexes = new ArrayList<Integer>(defaultList.size());
                for (int index = 0; index < defaultList.size(); ++index) {
                    allIndexes.add(index);
                }
                return allIndexes;
            }
            case OR: {
                ArrayList<Integer> indexesInRange = new ArrayList<Integer>();
                for (Integer orValue : this.keyInts) {
                    if (orValue >= container.size()) continue;
                    indexesInRange.add(orValue);
                }
                return indexesInRange;
            }
        }
        throw new IllegalStateException("Someone has added an op type without changing this method.");
    }
}

