/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.cardinality;

import com.bazaarvoice.jolt.cardinality.CardinalityLeafSpec;
import com.bazaarvoice.jolt.cardinality.CardinalitySpec;
import com.bazaarvoice.jolt.common.ComputedKeysComparator;
import com.bazaarvoice.jolt.common.pathelement.AmpPathElement;
import com.bazaarvoice.jolt.common.pathelement.AtPathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarPathElement;
import com.bazaarvoice.jolt.common.tree.MatchedElement;
import com.bazaarvoice.jolt.common.tree.WalkedPath;
import com.bazaarvoice.jolt.exception.SpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CardinalityCompositeSpec
extends CardinalitySpec {
    private static final HashMap<Class, Integer> orderMap = new HashMap();
    private static final ComputedKeysComparator computedKeysComparator;
    private CardinalityLeafSpec specialChild;
    private final Map<String, CardinalitySpec> literalChildren;
    private final List<CardinalitySpec> computedChildren;

    public CardinalityCompositeSpec(String rawKey, Map<String, Object> spec) {
        super(rawKey);
        HashMap<String, CardinalitySpec> literals = new HashMap<String, CardinalitySpec>();
        ArrayList<CardinalitySpec> computed = new ArrayList<CardinalitySpec>();
        this.specialChild = null;
        if (this.pathElement instanceof AtPathElement) {
            throw new SpecException("@ CardinalityTransform key, can not have children.");
        }
        List<CardinalitySpec> children = CardinalityCompositeSpec.createChildren(spec);
        if (children.isEmpty()) {
            throw new SpecException("Shift CardinalitySpec format error : CardinalitySpec line with empty {} as value is not valid.");
        }
        for (CardinalitySpec child : children) {
            literals.put(child.pathElement.getRawKey(), child);
            if (child.pathElement instanceof LiteralPathElement) {
                literals.put(child.pathElement.getRawKey(), child);
                continue;
            }
            if (child.pathElement instanceof AtPathElement) {
                if (child instanceof CardinalityLeafSpec) {
                    this.specialChild = (CardinalityLeafSpec)child;
                    continue;
                }
                throw new SpecException("@ CardinalityTransform key, can not have children.");
            }
            computed.add(child);
        }
        Collections.sort(computed, computedKeysComparator);
        computed.trimToSize();
        this.literalChildren = Collections.unmodifiableMap(literals);
        this.computedChildren = Collections.unmodifiableList(computed);
    }

    private static List<CardinalitySpec> createChildren(Map<String, Object> rawSpec) {
        ArrayList<CardinalitySpec> children = new ArrayList<CardinalitySpec>();
        HashSet<String> actualKeys = new HashSet<String>();
        for (String keyString : rawSpec.keySet()) {
            Object rawRhs = rawSpec.get(keyString);
            CardinalitySpec childSpec = rawRhs instanceof Map ? new CardinalityCompositeSpec(keyString, (Map)rawRhs) : new CardinalityLeafSpec(keyString, rawRhs);
            String childCanonicalString = childSpec.pathElement.getCanonicalForm();
            if (actualKeys.contains(childCanonicalString)) {
                throw new IllegalArgumentException("Duplicate canonical CardinalityTransform key found : " + childCanonicalString);
            }
            actualKeys.add(childCanonicalString);
            children.add(childSpec);
        }
        return children;
    }

    @Override
    public boolean applyCardinality(String inputKey, Object input, WalkedPath walkedPath, Object parentContainer) {
        MatchedElement thisLevel = this.pathElement.match(inputKey, walkedPath);
        if (thisLevel == null) {
            return false;
        }
        walkedPath.add(input, thisLevel);
        if (this.specialChild != null) {
            input = this.specialChild.applyToParentContainer(inputKey, input, walkedPath, parentContainer);
        }
        this.process(input, walkedPath);
        walkedPath.removeLast();
        return true;
    }

    private void process(Object input, WalkedPath walkedPath) {
        if (input instanceof Map) {
            HashSet entrySet = new HashSet(((Map)input).entrySet());
            for (Map.Entry entry : entrySet) {
                CardinalityCompositeSpec.applyKeyToLiteralAndComputed(this, (String)entry.getKey(), entry.getValue(), walkedPath, input);
            }
        } else if (input instanceof List) {
            for (int index = 0; index < ((List)input).size(); ++index) {
                Object subInput = ((List)input).get(index);
                String string = Integer.toString(index);
                CardinalityCompositeSpec.applyKeyToLiteralAndComputed(this, string, subInput, walkedPath, input);
            }
        } else if (input != null) {
            String scalarInput = input.toString();
            CardinalityCompositeSpec.applyKeyToLiteralAndComputed(this, scalarInput, null, walkedPath, scalarInput);
        }
    }

    private static void applyKeyToLiteralAndComputed(CardinalityCompositeSpec spec, String subKeyStr, Object subInput, WalkedPath walkedPath, Object input) {
        CardinalitySpec literalChild = spec.literalChildren.get(subKeyStr);
        if (literalChild != null) {
            literalChild.applyCardinality(subKeyStr, subInput, walkedPath, input);
        } else {
            for (CardinalitySpec computedChild : spec.computedChildren) {
                if (computedChild.applyCardinality(subKeyStr, subInput, walkedPath, input)) break;
            }
        }
    }

    static {
        orderMap.put(AmpPathElement.class, 1);
        orderMap.put(StarPathElement.class, 2);
        computedKeysComparator = ComputedKeysComparator.fromOrder(orderMap);
    }
}

