/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jackson.rison;

class IdentifierUtils {
    private static final int[] _idStartStrict = IdentifierUtils.toIdSet(true, "_./~");
    private static final int[] _idCharStrict = IdentifierUtils.toIdSet(true, "_./~-0123456789");
    private static final int[] _idStartLenient = IdentifierUtils.invert(IdentifierUtils.toIdSet(false, " '!:(),*@$-0123456789"));
    private static final int[] _idCharLenient = IdentifierUtils.invert(IdentifierUtils.toIdSet(false, " '!:(),*@$"));

    IdentifierUtils() {
    }

    public static boolean isIdStartLenient(int ch) {
        return ch > 127 || IdentifierUtils.in(ch, _idStartLenient);
    }

    public static boolean isIdCharLenient(int ch) {
        return ch > 127 || IdentifierUtils.in(ch, _idCharLenient);
    }

    public static boolean isIdStartStrict(int ch) {
        return ch > 127 || IdentifierUtils.in(ch, _idStartStrict);
    }

    public static boolean isIdCharStrict(int ch) {
        return ch > 127 || IdentifierUtils.in(ch, _idCharStrict);
    }

    public static boolean isIdStrict(String string) {
        int len = string.length();
        if (len == 0) {
            return false;
        }
        if (!IdentifierUtils.isIdStartStrict(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (IdentifierUtils.isIdCharStrict(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdStrict(char[] chars, int offset, int len) {
        if (len == 0) {
            return false;
        }
        int end = offset + len;
        if (!IdentifierUtils.isIdStartStrict(chars[offset++])) {
            return false;
        }
        while (offset < end) {
            if (IdentifierUtils.isIdCharStrict(chars[offset++])) continue;
            return false;
        }
        return true;
    }

    private static boolean in(int ch, int[] bits) {
        return (bits[ch >>> 5] & 1 << (ch & 0x1F)) != 0;
    }

    private static int[] toIdSet(boolean includeAlphaCharacters, String nonAlphaCharacters) {
        int[] bits = new int[4];
        if (includeAlphaCharacters) {
            int ch;
            for (ch = 65; ch <= 90; ++ch) {
                int n = ch >>> 5;
                bits[n] = bits[n] | 1 << (ch & 0x1F);
            }
            for (ch = 97; ch <= 122; ++ch) {
                int n = ch >>> 5;
                bits[n] = bits[n] | 1 << (ch & 0x1F);
            }
        }
        for (int i = 0; i < nonAlphaCharacters.length(); ++i) {
            char ch = nonAlphaCharacters.charAt(i);
            if (ch >= '\u0080') {
                throw new AssertionError();
            }
            int n = ch >>> 5;
            bits[n] = bits[n] | 1 << (ch & 0x1F);
        }
        return bits;
    }

    private static int[] invert(int[] bits) {
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = ~bits[i];
        }
        return bits;
    }
}

