/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.entity;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.entity.GlobalConfiguration;
import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.enums.FieldFill;
import com.baomidou.mybatisplus.enums.FieldStrategy;
import com.baomidou.mybatisplus.toolkit.SqlReservedWords;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.lang.reflect.Field;

public class TableFieldInfo {
    private boolean related = false;
    private String column;
    private String property;
    private String el;
    private Class<?> propertyType;
    private FieldStrategy fieldStrategy = FieldStrategy.NOT_NULL;
    private String logicDeleteValue;
    private String logicNotDeleteValue;
    private String update;
    private String condition = "%s=#{%s}";
    private FieldFill fieldFill = FieldFill.DEFAULT;

    public TableFieldInfo(GlobalConfiguration globalConfig, TableInfo tableInfo, String column, String el, Field field, TableField tableField) {
        this.property = field.getName();
        this.propertyType = field.getType();
        if (StringUtils.isEmpty(tableField.value()) && globalConfig.isDbColumnUnderline()) {
            this.related = true;
            this.setColumn(globalConfig, StringUtils.camelToUnderline(column));
        } else {
            this.setColumn(globalConfig, column);
            if (!column.equals(this.property)) {
                this.related = true;
            }
        }
        this.el = el;
        this.fieldStrategy = FieldStrategy.NOT_NULL != tableField.strategy() ? tableField.strategy() : globalConfig.getFieldStrategy();
        tableInfo.setLogicDelete(this.initLogicDelete(globalConfig, field));
        this.update = tableField.update();
        this.condition = tableField.condition();
        this.fieldFill = tableField.fill();
    }

    public TableFieldInfo(GlobalConfiguration globalConfig, TableInfo tableInfo, Field field) {
        if (globalConfig.isDbColumnUnderline()) {
            this.related = true;
            this.setColumn(globalConfig, StringUtils.camelToUnderline(field.getName()));
        } else {
            this.setColumn(globalConfig, field.getName());
        }
        this.property = field.getName();
        this.el = field.getName();
        this.fieldStrategy = globalConfig.getFieldStrategy();
        this.propertyType = field.getType();
        tableInfo.setLogicDelete(this.initLogicDelete(globalConfig, field));
    }

    private boolean initLogicDelete(GlobalConfiguration globalConfig, Field field) {
        if (null == globalConfig.getLogicDeleteValue()) {
            return false;
        }
        TableLogic tableLogic = field.getAnnotation(TableLogic.class);
        if (null != tableLogic) {
            this.logicNotDeleteValue = StringUtils.isNotEmpty(tableLogic.value()) ? tableLogic.value() : globalConfig.getLogicNotDeleteValue();
            this.logicDeleteValue = StringUtils.isNotEmpty(tableLogic.delval()) ? tableLogic.delval() : globalConfig.getLogicDeleteValue();
            return true;
        }
        return false;
    }

    public boolean isRelated() {
        return this.related;
    }

    public void setRelated(boolean related) {
        this.related = related;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(GlobalConfiguration globalConfig, String column) {
        String temp = SqlReservedWords.convert(globalConfig, column);
        if (globalConfig.isCapitalMode() && !this.isRelated()) {
            temp = temp.toUpperCase();
        }
        this.column = temp;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getEl() {
        return this.el;
    }

    public void setEl(String el) {
        this.el = el;
    }

    public FieldStrategy getFieldStrategy() {
        return this.fieldStrategy;
    }

    public void setFieldStrategy(FieldStrategy fieldStrategy) {
        this.fieldStrategy = fieldStrategy;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(Class<?> propertyType) {
        this.propertyType = propertyType;
    }

    public boolean isLogicDelete() {
        return StringUtils.isNotEmpty(this.logicDeleteValue);
    }

    public String getLogicDeleteValue() {
        return this.logicDeleteValue;
    }

    public void setLogicDeleteValue(String logicDeleteValue) {
        this.logicDeleteValue = logicDeleteValue;
    }

    public String getLogicNotDeleteValue() {
        return this.logicNotDeleteValue;
    }

    public void setLogicNotDeleteValue(String logicNotDeleteValue) {
        this.logicNotDeleteValue = logicNotDeleteValue;
    }

    public String getUpdate() {
        return this.update;
    }

    public void setUpdate(String update) {
        this.update = update;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public FieldFill getFieldFill() {
        return this.fieldFill;
    }

    public void setFieldFill(FieldFill fieldFill) {
        this.fieldFill = fieldFill;
    }
}

