/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.autoconfigure;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.ddl.DdlHelper;
import com.baomidou.mybatisplus.extension.ddl.IDdl;
import com.baomidou.mybatisplus.extension.ddl.history.IDdlGenerator;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public class DdlApplicationRunner
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(DdlApplicationRunner.class);
    private List<IDdl> ddlList;

    public DdlApplicationRunner(List<IDdl> ddlList) {
        this.ddlList = ddlList;
    }

    public void run(ApplicationArguments args) throws Exception {
        log.debug("  ...  DDL start create  ...  ");
        if (ObjectUtils.isNotEmpty(this.ddlList)) {
            this.ddlList.forEach(ddl -> ddl.runScript(dataSource -> DdlHelper.runScript((IDdlGenerator)ddl.getDdlGenerator(), (DataSource)dataSource, (List)ddl.getSqlFiles(), (boolean)true)));
        }
        log.debug("  ...  DDL end create  ...  ");
    }
}

