/*
 * Decompiled with CFR 0.152.
 */
package mybatis.mate.databind;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.Objects;
import mybatis.mate.annotation.FieldSensitive;
import mybatis.mate.databind.ISensitiveStrategy;
import mybatis.mate.databind.RequestDataTransfer;

public class SensitiveInfoSerialize
extends JsonSerializer<String>
implements ContextualSerializer {
    private static ISensitiveStrategy SENSITIVE_STRATEGY;
    private String type;

    public SensitiveInfoSerialize() {
    }

    public SensitiveInfoSerialize(String type) {
        this.type = type;
    }

    public static void setSensitiveStrategy(ISensitiveStrategy sensitiveStrategy) {
        SENSITIVE_STRATEGY = sensitiveStrategy;
    }

    public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (null == SENSITIVE_STRATEGY) {
            throw new RuntimeException("You used the annotation `@FieldSensitive` but did not inject `SensitiveStrategy`");
        }
        gen.writeObject((Object)("1".equals(RequestDataTransfer.get("skip_sensitive")) ? value : SENSITIVE_STRATEGY.handle(this.type, value)));
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        if (null != property) {
            if (Objects.equals(property.getType().getRawClass(), String.class)) {
                FieldSensitive sensitiveInfo = (FieldSensitive)property.getAnnotation(FieldSensitive.class);
                if (null == sensitiveInfo) {
                    sensitiveInfo = (FieldSensitive)property.getContextAnnotation(FieldSensitive.class);
                }
                if (null != sensitiveInfo) {
                    return new SensitiveInfoSerialize(sensitiveInfo.type());
                }
            }
            return prov.findValueSerializer(property.getType(), property);
        }
        return prov.findNullValueSerializer(null);
    }
}

