/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.trigger;

import com.baomidou.jobs.JobsClock;
import com.baomidou.jobs.api.JobsResponse;
import com.baomidou.jobs.exception.JobsException;
import com.baomidou.jobs.handler.IJobsResultHandler;
import com.baomidou.jobs.model.JobsInfo;
import com.baomidou.jobs.model.JobsLog;
import com.baomidou.jobs.model.param.TriggerParam;
import com.baomidou.jobs.service.IJobsService;
import com.baomidou.jobs.service.JobsHelper;
import com.baomidou.jobs.starter.JobsScheduler;
import com.baomidou.jobs.trigger.TriggerTypeEnum;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobsTrigger {
    private static final Logger log = LoggerFactory.getLogger(JobsTrigger.class);

    public static boolean trigger(Long jobId, TriggerTypeEnum triggerType, int failRetryCount, String executorParam) {
        JobsInfo jobsInfo = JobsHelper.getJobsService().getJobsInfoById(jobId);
        if (jobsInfo == null) {
            log.warn("Trigger fail, jobId invalid\uff0cjobId={}", (Object)jobId);
            return false;
        }
        if (executorParam != null) {
            jobsInfo.setParam(executorParam);
        }
        int finalFailRetryCount = failRetryCount >= 0 ? failRetryCount : jobsInfo.getFailRetryCount();
        return JobsTrigger.processTrigger(jobsInfo, finalFailRetryCount, triggerType);
    }

    private static boolean processTrigger(JobsInfo jobsInfo, int finalFailRetryCount, TriggerTypeEnum triggerType) {
        JobsResponse triggerResult;
        IJobsService jobsService = JobsHelper.getJobsService();
        JobsLog temp = new JobsLog();
        temp.setJobId(jobsInfo.getId());
        temp.setCreateTime(JobsClock.currentTimeMillis());
        log.debug("Jobs trigger start, jobId:{}", (Object)jobsInfo.getId());
        TriggerParam triggerParam = new TriggerParam();
        triggerParam.setJobId(jobsInfo.getId());
        triggerParam.setTenantId(jobsInfo.getTenantId());
        triggerParam.setHandler(jobsInfo.getHandler());
        triggerParam.setParam(jobsInfo.getParam());
        triggerParam.setTimeout(jobsInfo.getTimeout());
        int actualRetryCount = 0;
        List<String> registryList = jobsService.getAppAddressList(jobsInfo.getApp());
        if (null != registryList && 0 != registryList.size()) {
            String address = JobsHelper.getJobsExecutorRouter().route(jobsInfo.getApp(), registryList);
            temp.setAddress(address);
            triggerResult = JobsTrigger.runExecutor(triggerParam, address, registryList, finalFailRetryCount, actualRetryCount);
            JobsTrigger.jobsResultHandler(jobsInfo, address, triggerResult);
        } else {
            triggerResult = JobsResponse.failed("Trigger address is null");
            JobsTrigger.jobsResultHandler(jobsInfo, null, triggerResult);
        }
        temp.setHandler(jobsInfo.getHandler());
        temp.setParam(jobsInfo.getParam());
        temp.setFailRetryCount(actualRetryCount);
        temp.setTriggerCode(triggerResult.getCode());
        temp.setTriggerType(triggerType.getTitle());
        temp.setTriggerMsg(triggerResult.getMsg());
        jobsService.saveOrUpdateLogById(temp);
        log.debug("Jobs trigger end, jobId:{}", (Object)jobsInfo.getId());
        return true;
    }

    public static void jobsResultHandler(JobsInfo jobsInfo, String address, JobsResponse jobsResponse) {
        IJobsResultHandler jobsResultHandler = JobsHelper.getJobsResultHandler();
        if (null != jobsResultHandler) {
            jobsResultHandler.handle(jobsInfo, address, jobsResponse);
        }
    }

    public static JobsResponse runExecutor(TriggerParam triggerParam, String address, List<String> registryList, int failRetryCount, int actualRetryCount) {
        JobsResponse jobsResponse;
        try {
            jobsResponse = JobsScheduler.getJobsExecutor(address).run(triggerParam);
        }
        catch (JobsException e) {
            log.error("Trigger error, please check if the executor[{}] is running.", (Object)address, (Object)e);
            jobsResponse = JobsResponse.failed(JobsHelper.getErrorInfo(e));
        }
        if (-1 == jobsResponse.getCode() && failRetryCount > 0) {
            int i = 0;
            for (String registry : registryList) {
                if (address.equals(registry)) break;
                ++i;
            }
            int size = registryList.size();
            for (int j = 0; j < failRetryCount; ++j) {
                ++actualRetryCount;
                try {
                    jobsResponse = JobsScheduler.getJobsExecutor(registryList.get(i)).run(triggerParam);
                }
                catch (JobsException e) {
                    log.error("Trigger error, please check if the executor[{}] is running.", (Object)address, (Object)e);
                    jobsResponse = JobsResponse.failed(JobsHelper.getErrorInfo(e));
                }
                i = i < size - 1 ? ++i : 0;
                if (actualRetryCount == failRetryCount || 0 == jobsResponse.getCode()) break;
            }
        }
        return jobsResponse;
    }
}

