/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.toolkit;

import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConsistentHash<T> {
    private int virtualNodeCount = 1;
    private SortedMap<Integer, T> hashRing = new TreeMap<Integer, T>();

    public ConsistentHash() {
    }

    public ConsistentHash(int virtualNodeCount) {
        this.virtualNodeCount = virtualNodeCount;
    }

    public synchronized void add(T node) {
        for (int i = 0; i < this.virtualNodeCount; ++i) {
            this.addNode(node, i);
        }
    }

    public synchronized void add(Collection<T> nodes) {
        int i = 0;
        for (T node : nodes) {
            this.addNode(node, ++i);
        }
    }

    private void addNode(T node, int i) {
        this.hashRing.put(this.getHashKey(node, i), node);
    }

    public synchronized void remove(T node) {
        for (int i = 0; i < this.virtualNodeCount; ++i) {
            this.hashRing.remove(this.getHashKey(node, i));
        }
    }

    public int getHashKey(T node, int i) {
        return this.hash(new StringBuffer("HASH-").append(node.toString()).append("-NODE-").append(i).toString());
    }

    public T getNode(T key) {
        SortedMap<Integer, T> subMap = this.hashRing.tailMap(this.hash(key.toString()));
        if (subMap.isEmpty()) {
            return (T)this.hashRing.get(this.hashRing.firstKey());
        }
        return (T)subMap.get(subMap.firstKey());
    }

    private int hash(String key) {
        int p = 16777619;
        int hash = -2128831035;
        for (int i = 0; i < key.length(); ++i) {
            hash = (hash ^ key.charAt(i)) * 16777619;
        }
        hash += hash << 13;
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        if ((hash += hash << 5) < 0) {
            hash = Math.abs(hash);
        }
        return hash;
    }
}

