/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.thread;

import com.baomidou.jobs.executor.JobsAbstractExecutor;
import com.baomidou.jobs.model.param.RegisterStatusEnum;
import com.baomidou.jobs.model.param.RegistryParam;
import com.baomidou.jobs.service.IJobsService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorRegistryThread {
    private static final Logger log = LoggerFactory.getLogger(ExecutorRegistryThread.class);
    private static ExecutorRegistryThread INSTANCE = new ExecutorRegistryThread();
    private Thread registryThread;
    private volatile boolean toStop = false;

    public static ExecutorRegistryThread getInstance() {
        return INSTANCE;
    }

    public void start(String appName, String address) {
        if (appName == null || appName.trim().length() == 0) {
            log.warn("Jobs executor registry config fail, appName is null.");
            return;
        }
        if (null == JobsAbstractExecutor.getJobsServiceList()) {
            log.warn("Jobs executor registry config fail, adminAddresses is null.");
            return;
        }
        this.registryThread = new Thread(() -> {
            block16: {
                RegistryParam registryParam;
                while (!this.toStop) {
                    block15: {
                        try {
                            registryParam = new RegistryParam(appName, address);
                            for (IJobsService jobsService : JobsAbstractExecutor.getJobsServiceList()) {
                                try {
                                    if (jobsService.registry(registryParam)) {
                                        log.debug("Jobs registry success, registryParam:{}", (Object)registryParam);
                                        break;
                                    }
                                    log.info("Jobs registry fail, registryParam:{}", (Object)registryParam);
                                }
                                catch (Exception e) {
                                    log.info("Jobs registry error, registryParam:{}", (Object)registryParam, (Object)e);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (this.toStop) break block15;
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    try {
                        if (this.toStop) continue;
                        TimeUnit.SECONDS.sleep(30L);
                    }
                    catch (InterruptedException e) {
                        if (this.toStop) continue;
                        log.warn("Jobs executor registry thread interrupted, error msg:{}", (Object)e.getMessage());
                    }
                }
                try {
                    registryParam = new RegistryParam(appName, address);
                    for (IJobsService jobsService : JobsAbstractExecutor.getJobsServiceList()) {
                        try {
                            registryParam.setRegisterStatusEnum(RegisterStatusEnum.DISABLED);
                            if (jobsService.removeApp(registryParam)) {
                                log.info("Jobs registry-remove success, registryParam:{}", (Object)registryParam);
                                break;
                            }
                            log.info("Jobs registry-remove fail, registryParam:{}", (Object)registryParam);
                        }
                        catch (Exception e) {
                            if (this.toStop) continue;
                            log.info("Jobs registry-remove error, registryParam:{}", (Object)registryParam, (Object)e);
                        }
                    }
                }
                catch (Exception e) {
                    if (this.toStop) break block16;
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            log.info("Jobs executor registry thread destory.");
        });
        this.registryThread.setDaemon(true);
        this.registryThread.setName("Jobs executor ExecutorRegistryThread");
        this.registryThread.start();
    }

    public void toStop() {
        this.toStop = true;
        this.registryThread.interrupt();
        try {
            this.registryThread.join();
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

