/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.starter;

import com.baomidou.jobs.executor.IJobsExecutor;
import com.baomidou.jobs.rpc.remoting.invoker.JobsRpcInvokerFactory;
import com.baomidou.jobs.rpc.remoting.invoker.call.CallType;
import com.baomidou.jobs.rpc.remoting.invoker.reference.JobsRpcReferenceBean;
import com.baomidou.jobs.rpc.remoting.invoker.route.LoadBalance;
import com.baomidou.jobs.rpc.remoting.net.NetEnum;
import com.baomidou.jobs.rpc.remoting.net.impl.servlet.server.ServletServerHandler;
import com.baomidou.jobs.rpc.remoting.provider.JobsRpcProviderFactory;
import com.baomidou.jobs.service.IJobsService;
import com.baomidou.jobs.service.JobsHeartbeat;
import com.baomidou.jobs.service.JobsHelper;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JobsScheduler
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(JobsScheduler.class);
    private ScheduledExecutorService executor;
    private static ServletServerHandler servletServerHandler;
    private static Map<String, IJobsExecutor> JOBS_EXECUTOR;

    public void afterPropertiesSet() throws Exception {
        this.initRpcProvider();
        this.executor = new ScheduledThreadPoolExecutor(5);
        this.executor.scheduleAtFixedRate(new JobsHeartbeat(), 1L, 1L, TimeUnit.SECONDS);
        JobsHelper.getJobsService().cleanTimeoutApp();
        log.debug("init jobs admin success.");
    }

    public void destroy() throws Exception {
        if (null != this.executor) {
            this.executor.shutdown();
        }
        this.stopRpcProvider();
    }

    private void initRpcProvider() {
        JobsRpcProviderFactory jobsRpcProviderFactory = new JobsRpcProviderFactory();
        jobsRpcProviderFactory.initConfig(NetEnum.NETTY_HTTP, JobsHelper.getJobsRpcSerializer(), null, 0, JobsHelper.getJobsProperties().getAdminAccessToken(), null, null);
        jobsRpcProviderFactory.addService(IJobsService.class.getName(), null, JobsHelper.getJobsService());
        servletServerHandler = new ServletServerHandler(jobsRpcProviderFactory);
    }

    private void stopRpcProvider() throws Exception {
        JobsRpcInvokerFactory.getInstance().stop();
    }

    public static void invokeAdminService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        servletServerHandler.handle(null, request, response);
    }

    public static IJobsExecutor getJobsExecutor(String address) {
        if (address == null || address.trim().length() == 0) {
            return null;
        }
        IJobsExecutor jobsExecutor = JOBS_EXECUTOR.get(address = address.trim());
        if (jobsExecutor != null) {
            return jobsExecutor;
        }
        jobsExecutor = (IJobsExecutor)new JobsRpcReferenceBean(NetEnum.NETTY_HTTP, JobsHelper.getJobsRpcSerializer(), CallType.SYNC, LoadBalance.ROUND, IJobsExecutor.class, null, 5000L, address, JobsHelper.getJobsProperties().getAppAccessToken(), null, null).getObject();
        JOBS_EXECUTOR.put(address, jobsExecutor);
        return jobsExecutor;
    }

    static {
        JOBS_EXECUTOR = new ConcurrentHashMap<String, IJobsExecutor>();
    }
}

