/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.starter;

import com.baomidou.jobs.executor.JobsSpringExecutor;
import com.baomidou.jobs.rpc.serialize.impl.KryoRpcSerializer;
import com.baomidou.jobs.starter.JobsProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={JobsProperties.class})
public class JobsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public KryoRpcSerializer jobsRpcSerializer() {
        return new KryoRpcSerializer();
    }

    @Bean(initMethod="start", destroyMethod="destroy")
    public JobsSpringExecutor jobsSpringExecutor(JobsProperties jobsProperties) {
        JobsSpringExecutor jobsSpringExecutor = new JobsSpringExecutor();
        jobsSpringExecutor.setAccessToken(jobsProperties.getAdminAccessToken());
        jobsSpringExecutor.setAdminAddress(jobsProperties.getAdminAddress());
        jobsSpringExecutor.setApp(jobsProperties.getAppName());
        jobsSpringExecutor.setIp(jobsProperties.getAppIp());
        jobsSpringExecutor.setPort(jobsProperties.getAppPort());
        return jobsSpringExecutor;
    }
}

