/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.starter;

import com.baomidou.jobs.disruptor.JobsDisruptorTemplate;
import com.baomidou.jobs.disruptor.JobsEventHandler;
import com.baomidou.jobs.disruptor.JobsInfoEvent;
import com.baomidou.jobs.router.ExecutorConsistentHashRouter;
import com.baomidou.jobs.router.IJobsExecutorRouter;
import com.baomidou.jobs.rpc.serialize.impl.KryoRpcSerializer;
import com.baomidou.jobs.starter.JobsProperties;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.lmax.disruptor.util.DaemonThreadFactory;
import java.util.concurrent.ThreadFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={JobsProperties.class})
public class JobsAdminAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public KryoRpcSerializer jobsRpcSerializer() {
        return new KryoRpcSerializer();
    }

    @Bean
    @ConditionalOnMissingBean
    public CronParser cronParser(JobsProperties jobsProperties) {
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.valueOf((String)jobsProperties.getCronType()));
        return new CronParser(cronDefinition);
    }

    @Bean
    @ConditionalOnMissingBean
    public WaitStrategy waitStrategy() {
        return new SleepingWaitStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public ThreadFactory threadFactory() {
        return DaemonThreadFactory.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    public JobsEventHandler jobsEventHandler() {
        return new JobsEventHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public IJobsExecutorRouter jobsExecutorRouter() {
        return new ExecutorConsistentHashRouter();
    }

    @Bean
    @ConditionalOnClass(value={Disruptor.class})
    public Disruptor<JobsInfoEvent> disruptor(WaitStrategy waitStrategy, ThreadFactory threadFactory, JobsEventHandler jobsEventHandler) {
        Disruptor disruptor = new Disruptor(() -> new JobsInfoEvent(), 262144, threadFactory, ProducerType.MULTI, waitStrategy);
        disruptor.handleEventsWith(new EventHandler[]{jobsEventHandler});
        disruptor.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                disruptor.shutdown();
                RingBuffer ringBuffer = disruptor.getRingBuffer();
                for (int i = 0; i < 20 && !ringBuffer.hasAvailableCapacity(ringBuffer.getBufferSize()); ++i) {
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                disruptor.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        return disruptor;
    }

    @Bean
    public JobsDisruptorTemplate jobsDisruptorTemplate() {
        return new JobsDisruptorTemplate();
    }
}

