/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.service;

import com.baomidou.jobs.disruptor.JobsDisruptorTemplate;
import com.baomidou.jobs.handler.IJobsResultHandler;
import com.baomidou.jobs.router.IJobsExecutorRouter;
import com.baomidou.jobs.rpc.serialize.IJobsRpcSerializer;
import com.baomidou.jobs.service.IJobsService;
import com.baomidou.jobs.starter.JobsProperties;
import com.cronutils.model.Cron;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.ZonedDateTime;
import javax.annotation.Resource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JobsHelper
implements InitializingBean {
    private static JobsHelper JOB_HELPER = null;
    @Resource
    private CronParser _cronParser;
    @Resource
    private IJobsService _jobsService;
    @Resource
    private IJobsExecutorRouter _jobsExecutorRouter;
    @Resource
    private IJobsResultHandler _jobsResultHandler;
    @Resource
    private IJobsRpcSerializer _jobsRpcSerializer;
    @Resource
    private JobsProperties _jobsProperties;
    @Resource
    private JobsDisruptorTemplate _jobsDisruptorTemplate;

    public void afterPropertiesSet() throws Exception {
        JOB_HELPER = this;
    }

    public static CronParser getCronParser() {
        return JobsHelper.JOB_HELPER._cronParser;
    }

    public static boolean cronValidate(String expression) {
        try {
            JobsHelper.getCronParser().parse(expression).validate();
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static long cronNextTime(String expression) {
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)JobsHelper.getCronParser().parse(expression));
        return ((ZonedDateTime)executionTime.nextExecution(ZonedDateTime.now()).get()).toInstant().toEpochMilli();
    }

    public static IJobsService getJobsService() {
        return JobsHelper.JOB_HELPER._jobsService;
    }

    public static IJobsExecutorRouter getJobsExecutorRouter() {
        return JobsHelper.JOB_HELPER._jobsExecutorRouter;
    }

    public static IJobsResultHandler getJobsResultHandler() {
        return JobsHelper.JOB_HELPER._jobsResultHandler;
    }

    public static IJobsRpcSerializer getJobsRpcSerializer() {
        return JobsHelper.JOB_HELPER._jobsRpcSerializer;
    }

    public static JobsProperties getJobsProperties() {
        return JobsHelper.JOB_HELPER._jobsProperties;
    }

    public static JobsDisruptorTemplate getJobsDisruptorTemplate() {
        return JobsHelper.JOB_HELPER._jobsDisruptorTemplate;
    }

    public static String getErrorInfo(Throwable t) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            String str = sw.toString();
            sw.close();
            pw.close();
            return str;
        }
        catch (Exception ex) {
            return "\u83b7\u5f97Exception\u4fe1\u606f\u7684\u5f02\u5e38";
        }
    }
}

